/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.core.model;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.webui.core.model.SelectItemOption;

public class SelectItemCategory<T> {
    private String name;
    private String label;
    private List<SelectItemOption<T>> options;
    protected boolean selected = false;

    public SelectItemCategory() {
    }

    public SelectItemCategory(String name) {
        this.name = name;
    }

    public SelectItemCategory(String name, boolean selected) {
        this.name = name;
        this.label = name;
        this.selected = selected;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean b) {
        this.selected = b;
    }

    public List<SelectItemOption<T>> getSelectItemOptions() {
        return this.options;
    }

    public void setSelectItemOptions(List<SelectItemOption<T>> options) {
        this.options = options;
    }

    public SelectItemCategory<T> addSelectItemOption(SelectItemOption<T> option) {
        if (this.options == null) {
            this.options = new ArrayList<SelectItemOption<T>>();
        }
        this.options.add(option);
        return this;
    }

    public SelectItemOption<T> getSelectedItemOption() {
        if (this.options == null) {
            return null;
        }
        for (SelectItemOption<T> item : this.options) {
            if (!item.isSelected()) continue;
            return item;
        }
        return this.options.get(0);
    }
}

