/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression;

import org.hibernate.metamodel.model.domain.EmbeddableDomainType;
import org.hibernate.persister.entity.DiscriminatorHelper;
import org.hibernate.query.hql.HqlInterpretationException;
import org.hibernate.query.hql.spi.SemanticPathPart;
import org.hibernate.query.hql.spi.SqmCreationState;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.expression.AbstractSqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.select.SqmSelectableNode;

public class SqmLiteralEmbeddableType<T>
extends AbstractSqmExpression<T>
implements SqmSelectableNode<T>,
SemanticPathPart {
    final EmbeddableDomainType<T> embeddableDomainType;

    public SqmLiteralEmbeddableType(EmbeddableDomainType<T> embeddableDomainType, NodeBuilder nodeBuilder) {
        super(DiscriminatorHelper.getDiscriminatorType(embeddableDomainType, nodeBuilder), nodeBuilder);
        this.embeddableDomainType = embeddableDomainType;
    }

    public EmbeddableDomainType<T> getEmbeddableDomainType() {
        return this.embeddableDomainType;
    }

    @Override
    public SqmLiteralEmbeddableType<T> copy(SqmCopyContext context) {
        SqmLiteralEmbeddableType existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        SqmLiteralEmbeddableType<T> expression = context.registerCopy(this, new SqmLiteralEmbeddableType<T>(this.embeddableDomainType, (NodeBuilder)this.nodeBuilder()));
        this.copyTo(expression, context);
        return expression;
    }

    @Override
    public void internalApplyInferableType(SqmExpressible<?> type) {
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitEmbeddableTypeLiteralExpression(this);
    }

    @Override
    public String asLoggableText() {
        return "TYPE(" + String.valueOf(this.embeddableDomainType) + ")";
    }

    @Override
    public SemanticPathPart resolvePathPart(String name, boolean isTerminal, SqmCreationState creationState) {
        throw new HqlInterpretationException("Cannot dereference an embeddable name");
    }

    @Override
    public SqmPath<?> resolveIndexedAccess(SqmExpression<?> selector, boolean isTerminal, SqmCreationState creationState) {
        throw new HqlInterpretationException("Cannot dereference an embeddable name");
    }

    @Override
    public void appendHqlString(StringBuilder sb) {
        sb.append(this.embeddableDomainType.getTypeName());
    }
}

