/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.listener;

import io.meeds.gamification.constant.RealizationStatus;
import io.meeds.gamification.model.Announcement;
import io.meeds.gamification.model.RealizationDTO;
import io.meeds.gamification.service.RealizationService;
import java.util.Map;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.manager.ActivityManager;

public class AnnouncementRealizationUpdater
extends Listener<Object, Object> {
    private final ActivityManager activityManager;
    private final RealizationService realizationService;

    public AnnouncementRealizationUpdater(ActivityManager activityManager, RealizationService realizationService) {
        this.activityManager = activityManager;
        this.realizationService = realizationService;
    }

    public void onEvent(Event<Object, Object> event) throws Exception {
        ExoSocialActivity announcementComment;
        RealizationDTO realization = this.getRealization(event.getSource());
        if (realization == null) {
            return;
        }
        if (!RealizationStatus.CANCELED.name().equals(realization.getStatus()) && !RealizationStatus.DELETED.name().equals(realization.getStatus()) && realization.getActivityId() != null && (announcementComment = this.activityManager.getActivity(String.valueOf(realization.getActivityId()))) != null) {
            Map templateParams = announcementComment.getTemplateParams();
            templateParams.put("realizationStatus", String.valueOf(realization.getStatus()));
            announcementComment.setTemplateParams(templateParams);
            this.activityManager.updateActivity(announcementComment);
        }
    }

    private RealizationDTO getRealization(Object object) {
        if (object instanceof RealizationDTO) {
            RealizationDTO realization = (RealizationDTO)object;
            return realization;
        }
        if (object instanceof Announcement) {
            Announcement announcement = (Announcement)object;
            return this.realizationService.getRealizationById(announcement.getId());
        }
        return null;
    }
}

