/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.security.web;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpSessionEvent;
import jakarta.servlet.http.HttpSessionListener;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationRegistry;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.web.HttpSessionStateKey;

public class ConversationStateListener
implements HttpSessionListener {
    protected static final Log LOG = ExoLogger.getLogger((String)"exo.core.component.security.core.ConversationStateListener");

    public void sessionCreated(HttpSessionEvent event) {
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        ConversationRegistry conversationRegistry;
        ConversationState conversationState;
        HttpSession httpSession = event.getSession();
        HttpSessionStateKey stateKey = new HttpSessionStateKey(httpSession);
        ExoContainer container = this.getContainerIfPresent(httpSession.getServletContext());
        if (container != null && (conversationState = (conversationRegistry = (ConversationRegistry)container.getComponentInstanceOfType(ConversationRegistry.class)).unregister(stateKey)) != null && LOG.isDebugEnabled()) {
            LOG.debug((Object)("Remove conversation state " + httpSession.getId()));
        }
    }

    protected ExoContainer getContainerIfPresent(ServletContext sctx) {
        ExoContainer container = ExoContainerContext.getCurrentContainerIfPresent();
        if (container instanceof RootContainer && (container = PortalContainer.getCurrentInstance((ServletContext)sctx)) == null) {
            container = ExoContainerContext.getTopContainer();
        }
        return container;
    }
}

