/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.core.identity.model;

import lombok.Generated;

public class UserExportResult {
    private static final long MAX_DELAY_DOWNLOAD = 3600000L;
    private String username;
    private String exportId;
    private String exportPath;
    private long processedCount;
    private boolean finished;
    private long startTime = System.currentTimeMillis();
    private long endTime;

    public String retrieveExportPath() {
        return this.exportPath;
    }

    protected String getExportPath() {
        return this.exportPath;
    }

    public void incrementProcessed() {
        ++this.processedCount;
    }

    public void setFinished(boolean finished) {
        this.endTime = finished ? System.currentTimeMillis() : 0L;
        this.finished = finished;
    }

    public long getProcessingTime() {
        return (this.finished ? System.currentTimeMillis() : this.endTime) - this.startTime;
    }

    public boolean isOutdated() {
        return this.finished && System.currentTimeMillis() - this.endTime > 3600000L;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getExportId() {
        return this.exportId;
    }

    @Generated
    public long getProcessedCount() {
        return this.processedCount;
    }

    @Generated
    public boolean isFinished() {
        return this.finished;
    }

    @Generated
    public long getStartTime() {
        return this.startTime;
    }

    @Generated
    public long getEndTime() {
        return this.endTime;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setExportId(String exportId) {
        this.exportId = exportId;
    }

    @Generated
    public void setExportPath(String exportPath) {
        this.exportPath = exportPath;
    }

    @Generated
    public void setProcessedCount(long processedCount) {
        this.processedCount = processedCount;
    }

    @Generated
    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    @Generated
    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserExportResult)) {
            return false;
        }
        UserExportResult other = (UserExportResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getProcessedCount() != other.getProcessedCount()) {
            return false;
        }
        if (this.isFinished() != other.isFinished()) {
            return false;
        }
        if (this.getStartTime() != other.getStartTime()) {
            return false;
        }
        if (this.getEndTime() != other.getEndTime()) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$exportId = this.getExportId();
        String other$exportId = other.getExportId();
        if (this$exportId == null ? other$exportId != null : !this$exportId.equals(other$exportId)) {
            return false;
        }
        String this$exportPath = this.getExportPath();
        String other$exportPath = other.getExportPath();
        return !(this$exportPath == null ? other$exportPath != null : !this$exportPath.equals(other$exportPath));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof UserExportResult;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $processedCount = this.getProcessedCount();
        result = result * 59 + (int)($processedCount >>> 32 ^ $processedCount);
        result = result * 59 + (this.isFinished() ? 79 : 97);
        long $startTime = this.getStartTime();
        result = result * 59 + (int)($startTime >>> 32 ^ $startTime);
        long $endTime = this.getEndTime();
        result = result * 59 + (int)($endTime >>> 32 ^ $endTime);
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $exportId = this.getExportId();
        result = result * 59 + ($exportId == null ? 43 : $exportId.hashCode());
        String $exportPath = this.getExportPath();
        result = result * 59 + ($exportPath == null ? 43 : $exportPath.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "UserExportResult(username=" + this.getUsername() + ", exportId=" + this.getExportId() + ", exportPath=" + this.getExportPath() + ", processedCount=" + this.getProcessedCount() + ", finished=" + this.isFinished() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ")";
    }

    @Generated
    public UserExportResult(String username, String exportId, String exportPath, long processedCount, boolean finished, long startTime, long endTime) {
        this.username = username;
        this.exportId = exportId;
        this.exportPath = exportPath;
        this.processedCount = processedCount;
        this.finished = finished;
        this.startTime = startTime;
        this.endTime = endTime;
    }

    @Generated
    public UserExportResult() {
    }
}

