/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.sql.internal;

import jakarta.persistence.criteria.Selection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.FunctionalDependencyAnalysisSupport;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.metamodel.mapping.EntityAssociationMapping;
import org.hibernate.metamodel.mapping.EntityDiscriminatorMapping;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.EntityValuedModelPart;
import org.hibernate.metamodel.mapping.MappingModelExpressible;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.SelectableConsumer;
import org.hibernate.metamodel.mapping.ValuedModelPart;
import org.hibernate.metamodel.mapping.internal.EntityCollectionPart;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.persister.entity.UnionSubclassEntityPersister;
import org.hibernate.query.derived.AnonymousTupleEntityValuedModelPart;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.query.sqm.sql.internal.AbstractSqmPathInterpretation;
import org.hibernate.query.sqm.tree.domain.SqmEntityValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.select.SqmDynamicInstantiation;
import org.hibernate.query.sqm.tree.select.SqmDynamicInstantiationArgument;
import org.hibernate.query.sqm.tree.select.SqmQuerySpec;
import org.hibernate.query.sqm.tree.select.SqmSelection;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.expression.SqlTupleContainer;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.update.Assignable;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetchable;

public class EntityValuedPathInterpretation<T>
extends AbstractSqmPathInterpretation<T>
implements SqlTupleContainer,
Assignable {
    private final Expression sqlExpression;

    public static <T> EntityValuedPathInterpretation<T> from(SqmEntityValuedSimplePath<T> sqmPath, MappingModelExpressible<?> inferredMapping, SqmToSqlAstConverter sqlAstCreationState) {
        TableGroup tableGroup = sqlAstCreationState.getFromClauseAccess().findTableGroup(sqmPath.getNavigablePath());
        EntityValuedModelPart pathMapping = (EntityValuedModelPart)tableGroup.getModelPart();
        if (inferredMapping instanceof EntityAssociationMapping) {
            EntityAssociationMapping inferredAssociation = (EntityAssociationMapping)inferredMapping;
            if (pathMapping instanceof EntityAssociationMapping && inferredMapping != pathMapping) {
                ValuedModelPart inferredTargetPart;
                EntityAssociationMapping pathAssociation = (EntityAssociationMapping)((Object)pathMapping);
                ValuedModelPart pathTargetPart = pathAssociation.getForeignKeyDescriptor().getPart(pathAssociation.getSideNature().inverse());
                if (pathTargetPart == (inferredTargetPart = inferredAssociation.getForeignKeyDescriptor().getPart(inferredAssociation.getSideNature().inverse()))) {
                    return EntityValuedPathInterpretation.from(sqmPath.getNavigablePath(), tableGroup, pathMapping, inferredMapping, sqlAstCreationState);
                }
                if (pathAssociation.isReferenceToPrimaryKey()) {
                    return EntityValuedPathInterpretation.from(sqmPath.getNavigablePath(), tableGroup, pathMapping, inferredMapping, sqlAstCreationState);
                }
                return EntityValuedPathInterpretation.from(sqmPath.getNavigablePath(), tableGroup, pathMapping.getEntityMappingType().getIdentifierMapping(), pathMapping, pathMapping, sqlAstCreationState);
            }
            if (pathMapping instanceof AnonymousTupleEntityValuedModelPart) {
                return EntityValuedPathInterpretation.from(sqmPath.getNavigablePath(), tableGroup, pathMapping, inferredMapping, sqlAstCreationState);
            }
            return EntityValuedPathInterpretation.from(sqmPath.getNavigablePath(), tableGroup, (EntityValuedModelPart)inferredMapping, inferredMapping, sqlAstCreationState);
        }
        return EntityValuedPathInterpretation.from(sqmPath.getNavigablePath(), tableGroup, pathMapping, inferredMapping, sqlAstCreationState);
    }

    private static <T> EntityValuedPathInterpretation<T> from(NavigablePath navigablePath, TableGroup tableGroup, EntityValuedModelPart mapping, MappingModelExpressible<?> inferredMapping, SqmToSqlAstConverter sqlAstCreationState) {
        TableGroup resultTableGroup;
        ModelPart resultModelPart;
        if (mapping instanceof EntityAssociationMapping) {
            EntityAssociationMapping associationMapping = (EntityAssociationMapping)((Object)mapping);
            ValuedModelPart keyTargetMatchPart = associationMapping.getForeignKeyDescriptor().getPart(associationMapping.getSideNature());
            if (associationMapping.isFkOptimizationAllowed()) {
                boolean forceUsingForeignKeyAssociationSidePart;
                if (inferredMapping != null && EntityValuedPathInterpretation.hasJoinTable(associationMapping)) {
                    if (inferredMapping instanceof EntityMappingType) {
                        forceUsingForeignKeyAssociationSidePart = ((EntityMappingType)inferredMapping).findSubPart(keyTargetMatchPart.getPartName()) != null;
                    } else {
                        assert (inferredMapping instanceof EntityAssociationMapping);
                        forceUsingForeignKeyAssociationSidePart = ((EntityAssociationMapping)inferredMapping).getKeyTargetMatchPart() != keyTargetMatchPart && associationMapping.isReferenceToPrimaryKey();
                    }
                } else {
                    forceUsingForeignKeyAssociationSidePart = false;
                }
                if (forceUsingForeignKeyAssociationSidePart) {
                    resultModelPart = associationMapping.getForeignKeyDescriptor().getPart(associationMapping.getSideNature());
                    resultTableGroup = sqlAstCreationState.getFromClauseAccess().findTableGroup(tableGroup.getNavigablePath().getParent());
                } else {
                    resultModelPart = !tableGroup.getNavigablePath().isParentOrEqual(navigablePath) ? associationMapping.getForeignKeyDescriptor().getPart(associationMapping.getSideNature().inverse()) : keyTargetMatchPart;
                    resultTableGroup = tableGroup;
                }
            } else if (inferredMapping == null && EntityValuedPathInterpretation.hasNotFound(mapping) && sqlAstCreationState.getCurrentClauseStack().getCurrent() == Clause.SET) {
                resultModelPart = keyTargetMatchPart;
                resultTableGroup = sqlAstCreationState.getFromClauseAccess().findTableGroup(tableGroup.getNavigablePath().getParent());
            } else {
                resultModelPart = associationMapping.getAssociatedEntityMappingType().getIdentifierMapping();
                resultTableGroup = tableGroup;
            }
        } else if (mapping instanceof AnonymousTupleEntityValuedModelPart) {
            resultModelPart = ((AnonymousTupleEntityValuedModelPart)mapping).getForeignKeyPart();
            resultTableGroup = tableGroup;
        } else {
            resultModelPart = mapping.getEntityMappingType().getIdentifierMapping();
            resultTableGroup = tableGroup;
        }
        return EntityValuedPathInterpretation.from(navigablePath, resultTableGroup, resultModelPart, mapping, mapping, sqlAstCreationState);
    }

    private static boolean hasNotFound(EntityValuedModelPart mapping) {
        return mapping instanceof ToOneAttributeMapping && ((ToOneAttributeMapping)mapping).hasNotFoundAction();
    }

    private static boolean hasJoinTable(EntityAssociationMapping associationMapping) {
        return associationMapping instanceof EntityCollectionPart && ((EntityCollectionPart)((Object)associationMapping)).getCardinality() == EntityCollectionPart.Cardinality.MANY_TO_MANY;
    }

    public static <T> EntityValuedPathInterpretation<T> from(NavigablePath navigablePath, TableGroup tableGroup, ModelPart resultModelPart, EntityValuedModelPart mapping, EntityValuedModelPart treatedMapping, SqmToSqlAstConverter sqlAstCreationState) {
        Expression sqlExpression;
        boolean expandToAllColumns;
        Clause currentClause = sqlAstCreationState.getCurrentClauseStack().getCurrent();
        if (currentClause == Clause.GROUP || currentClause == Clause.ORDER) {
            assert (sqlAstCreationState.getCurrentSqmQueryPart().isSimpleQueryPart());
            SqmQuerySpec<?> querySpec = sqlAstCreationState.getCurrentSqmQueryPart().getFirstQuerySpec();
            expandToAllColumns = currentClause == Clause.ORDER && !querySpec.groupByClauseContains(navigablePath, sqlAstCreationState) ? false : EntityValuedPathInterpretation.isSelected(tableGroup, navigablePath, querySpec, sqlAstCreationState.getCurrentProcessingState().isTopLevel());
        } else {
            expandToAllColumns = false;
        }
        SqlExpressionResolver sqlExprResolver = sqlAstCreationState.getSqlExpressionResolver();
        if (expandToAllColumns) {
            Dialect dialect = sqlAstCreationState.getCreationContext().getSessionFactory().getJdbcServices().getDialect();
            EntityMappingType entityMappingType = mapping.getEntityMappingType();
            EntityIdentifierMapping identifierMapping = entityMappingType.getIdentifierMapping();
            ArrayList<Expression> expressions = new ArrayList<Expression>(identifierMapping.getJdbcTypeCount());
            SelectableConsumer selectableConsumer = (selectionIndex, selectableMapping) -> {
                TableReference tableReference = tableGroup.resolveTableReference(navigablePath, selectableMapping.getContainingTableExpression());
                expressions.add(sqlExprResolver.resolveSqlExpression(tableReference, selectableMapping));
            };
            identifierMapping.forEachSelectable(selectableConsumer);
            if (!EntityValuedPathInterpretation.supportsFunctionalDependency(dialect, entityMappingType)) {
                EntityDiscriminatorMapping discriminatorMapping = entityMappingType.getDiscriminatorMapping();
                if (discriminatorMapping != null) {
                    expressions.add(discriminatorMapping.resolveSqlExpression(navigablePath, discriminatorMapping.getUnderlyingJdbcMapping(), tableGroup, sqlAstCreationState));
                }
                for (int i = 0; i < entityMappingType.getNumberOfFetchables(); ++i) {
                    Fetchable fetchable = entityMappingType.getFetchable(i);
                    if (!fetchable.isSelectable()) continue;
                    fetchable.forEachSelectable(selectableConsumer);
                }
            }
            sqlExpression = new SqlTuple(expressions, entityMappingType);
        } else {
            BasicValuedModelPart basicValuedModelPart = resultModelPart.asBasicValuedModelPart();
            if (basicValuedModelPart != null) {
                TableReference tableReference = tableGroup.resolveTableReference(navigablePath, basicValuedModelPart, basicValuedModelPart.getContainingTableExpression());
                sqlExpression = sqlExprResolver.resolveSqlExpression(tableReference, basicValuedModelPart);
            } else {
                ArrayList expressions = new ArrayList(resultModelPart.getJdbcTypeCount());
                resultModelPart.forEachSelectable((selectionIndex, selectableMapping) -> {
                    TableReference tableReference = tableGroup.resolveTableReference(navigablePath, (ValuedModelPart)resultModelPart, selectableMapping.getContainingTableExpression());
                    expressions.add(sqlExprResolver.resolveSqlExpression(tableReference, selectableMapping));
                });
                sqlExpression = new SqlTuple(expressions, resultModelPart);
            }
        }
        return new EntityValuedPathInterpretation<T>(sqlExpression, navigablePath, tableGroup, treatedMapping);
    }

    private static boolean isSelected(TableGroup tableGroup, NavigablePath path, SqmQuerySpec<?> sqmQuerySpec, boolean isTopLevel) {
        if (!tableGroup.isInitialized() || sqmQuerySpec.getSelectClause() == null) {
            return false;
        }
        NavigablePath tableGroupPath = isTopLevel ? null : tableGroup.getNavigablePath();
        for (SqmSelection<?> selection : sqmQuerySpec.getSelectClause().getSelections()) {
            if (!EntityValuedPathInterpretation.selectionContains(selection.getSelectableNode(), path, tableGroupPath)) continue;
            return true;
        }
        return false;
    }

    private static boolean selectionContains(Selection<?> selection, NavigablePath path, NavigablePath tableGroupPath) {
        block4: {
            block3: {
                if (selection instanceof SqmPath) {
                    SqmPath sqmPath = (SqmPath)selection;
                    return (tableGroupPath == null || sqmPath.getLhs() != null && sqmPath.getLhs().getNavigablePath().equals(tableGroupPath)) && path.isParentOrEqual(sqmPath.getNavigablePath());
                }
                if (!selection.isCompoundSelection()) break block3;
                for (Selection compoundSelection : selection.getCompoundSelectionItems()) {
                    if (!EntityValuedPathInterpretation.selectionContains(compoundSelection, path, tableGroupPath)) continue;
                    return true;
                }
                break block4;
            }
            if (!(selection instanceof SqmDynamicInstantiation)) break block4;
            for (SqmDynamicInstantiationArgument<?> argument : ((SqmDynamicInstantiation)selection).getArguments()) {
                if (!EntityValuedPathInterpretation.selectionContains(argument.getSelectableNode(), path, tableGroupPath)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean supportsFunctionalDependency(Dialect dialect, EntityMappingType entityMappingType) {
        FunctionalDependencyAnalysisSupport analysisSupport = dialect.getFunctionalDependencyAnalysisSupport();
        if (analysisSupport.supportsAnalysis()) {
            if (entityMappingType.getSqmMultiTableMutationStrategy() == null) {
                return analysisSupport.supportsTableGroups() || entityMappingType.getSuperMappingType() == null;
            }
            return analysisSupport.supportsTableGroups() && (analysisSupport.supportsConstants() || !(entityMappingType.getEntityPersister() instanceof UnionSubclassEntityPersister));
        }
        return false;
    }

    public EntityValuedPathInterpretation(Expression sqlExpression, NavigablePath navigablePath, TableGroup tableGroup, EntityValuedModelPart mapping) {
        super(navigablePath, mapping, tableGroup);
        this.sqlExpression = sqlExpression;
    }

    @Override
    public Expression getSqlExpression() {
        return this.sqlExpression;
    }

    @Override
    public void accept(SqlAstWalker sqlTreeWalker) {
        this.sqlExpression.accept(sqlTreeWalker);
    }

    @Override
    public List<ColumnReference> getColumnReferences() {
        if (this.sqlExpression instanceof SqlTuple) {
            return ((SqlTuple)this.sqlExpression).getExpressions();
        }
        return Collections.singletonList((ColumnReference)this.sqlExpression);
    }

    @Override
    public void visitColumnReferences(Consumer<ColumnReference> columnReferenceConsumer) {
        if (this.sqlExpression instanceof SqlTuple) {
            for (Expression expression : ((SqlTuple)this.sqlExpression).getExpressions()) {
                columnReferenceConsumer.accept((ColumnReference)expression);
            }
        } else {
            columnReferenceConsumer.accept((ColumnReference)this.sqlExpression);
        }
    }

    @Override
    public SqlTuple getSqlTuple() {
        return this.sqlExpression instanceof SqlTuple ? (SqlTuple)this.sqlExpression : null;
    }

    @Override
    public void applySqlSelections(DomainResultCreationState creationState) {
        this.applySqlSelections(this.sqlExpression, creationState.getSqlAstCreationState());
    }

    private void applySqlSelections(Expression sqlExpression, SqlAstCreationState creationState) {
        if (sqlExpression instanceof SqlTuple) {
            for (Expression expression : ((SqlTuple)sqlExpression).getExpressions()) {
                this.applySqlSelections(expression, creationState);
            }
        } else {
            creationState.getSqlExpressionResolver().resolveSqlSelection(sqlExpression, this.getExpressionType().getJavaType(), null, creationState.getCreationContext().getMappingMetamodel().getTypeConfiguration());
        }
    }

    @Override
    public EntityValuedModelPart getExpressionType() {
        return (EntityValuedModelPart)super.getExpressionType();
    }
}

