/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.notes.notifications.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.ArgumentLiteral;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.social.notification.Utils;

public class MentionInNoteNotificationPlugin
extends BaseNotificationPlugin {
    public static final String ID = "MentionInNoteNotificationPlugin";
    private static final Log LOG = ExoLogger.getLogger(MentionInNoteNotificationPlugin.class);
    public static final ArgumentLiteral<String> CURRENT_USER = new ArgumentLiteral(String.class, "CURRENT_USER");
    public static final ArgumentLiteral<String> NOTE_AUTHOR = new ArgumentLiteral(String.class, "NOTE_AUTHOR");
    public static final ArgumentLiteral<String> AUTHOR_AVATAR_URL = new ArgumentLiteral(String.class, "AUTHOR_AVATAR_URL");
    public static final ArgumentLiteral<String> AUTHOR_PROFILE_URL = new ArgumentLiteral(String.class, "AUTHOR_PROFILE_URL");
    public static final ArgumentLiteral<String> ACTIVITY_LINK = new ArgumentLiteral(String.class, "ACTIVITY_LINK");
    public static final ArgumentLiteral<Set> MENTIONED_IDS = new ArgumentLiteral(Set.class, "MENTIONED_IDS");
    public static final ArgumentLiteral<String> NOTE_URL = new ArgumentLiteral(String.class, "NOTE_URL");
    public static final ArgumentLiteral<String> NOTE_TITLE = new ArgumentLiteral(String.class, "NOTE_TITLE");
    public static final ArgumentLiteral<String> SPACE_ID = new ArgumentLiteral(String.class, "SPACE_ID");

    public MentionInNoteNotificationPlugin(InitParams initParams) {
        super(initParams);
    }

    public String getId() {
        return ID;
    }

    public boolean isValid(NotificationContext ctx) {
        return true;
    }

    public NotificationInfo makeNotification(NotificationContext ctx) {
        String currentUserName;
        String currentUserFullName = currentUserName = (String)ctx.value(CURRENT_USER);
        try {
            currentUserFullName = this.getUserFullName(currentUserName);
        }
        catch (Exception e) {
            LOG.error((Object)("An error occured when trying to retreive a user with username " + currentUserName + " " + e.getMessage()), (Throwable)e);
        }
        ArrayList mentionedIds = new ArrayList((Collection)ctx.value(MENTIONED_IDS));
        String spaceId = (String)ctx.value(SPACE_ID);
        HashSet receivers = new HashSet();
        String[] mentionnedIdArray = new String[mentionedIds.size()];
        Utils.sendToMentioners(receivers, (String[])mentionedIds.toArray(mentionnedIdArray), (String)currentUserName, (String)spaceId);
        return NotificationInfo.instance().setFrom(currentUserName).to(new ArrayList(receivers)).key(this.getKey()).with(NOTE_URL.getKey(), (String)ctx.value(NOTE_URL)).with(NOTE_TITLE.getKey(), (String)ctx.value(NOTE_TITLE)).with(NOTE_AUTHOR.getKey(), (String)ctx.value(NOTE_AUTHOR)).with(AUTHOR_AVATAR_URL.getKey(), (String)ctx.value(AUTHOR_AVATAR_URL)).with(AUTHOR_PROFILE_URL.getKey(), (String)ctx.value(AUTHOR_PROFILE_URL)).with(ACTIVITY_LINK.getKey(), (String)ctx.value(ACTIVITY_LINK)).with(MENTIONED_IDS.getKey(), String.valueOf(mentionedIds)).with(CURRENT_USER.getKey(), currentUserFullName).end();
    }

    private String getUserFullName(String userName) throws Exception {
        OrganizationService organizationService = (OrganizationService)CommonsUtils.getService(OrganizationService.class);
        UserHandler userHandler = organizationService.getUserHandler();
        User user = userHandler.findUserByName(userName);
        if (user == null) {
            throw new Exception("An error occured when trying to retreive a user with username " + userName);
        }
        return user.getFullName();
    }
}

