/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.query;

import java.util.Map;
import java.util.function.Function;
import org.springframework.data.elasticsearch.core.query.ScriptType;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public record ScriptData(ScriptType type, @Nullable String language, @Nullable String script, @Nullable String scriptName, @Nullable Map<String, Object> params) {
    public ScriptData {
        Assert.notNull((Object)((Object)type), (String)"type must not be null");
    }

    public static ScriptData of(ScriptType type, @Nullable String language, @Nullable String script, @Nullable String scriptName, @Nullable Map<String, Object> params) {
        return new ScriptData(type, language, script, scriptName, params);
    }

    public static ScriptData of(Function<Builder, Builder> builderFunction) {
        Assert.notNull(builderFunction, (String)"f must not be null");
        return builderFunction.apply(new Builder()).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private ScriptType type;
        @Nullable
        private String language;
        @Nullable
        private String script;
        @Nullable
        private String scriptName;
        @Nullable
        private Map<String, Object> params;

        private Builder() {
        }

        public Builder withType(ScriptType type) {
            Assert.notNull((Object)((Object)type), (String)"type must not be null");
            this.type = type;
            return this;
        }

        public Builder withLanguage(@Nullable String language) {
            this.language = language;
            return this;
        }

        public Builder withScript(@Nullable String script) {
            this.script = script;
            return this;
        }

        public Builder withScriptName(@Nullable String scriptName) {
            this.scriptName = scriptName;
            return this;
        }

        public Builder withParams(@Nullable Map<String, Object> params) {
            this.params = params;
            return this;
        }

        public ScriptData build() {
            Assert.notNull((Object)((Object)this.type), (String)"type must be set");
            return new ScriptData(this.type, this.language, this.script, this.scriptName, this.params);
        }
    }
}

