/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.pc;

import java.util.Locale;
import java.util.ResourceBundle;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.resources.ResourceBundleService;
import org.gatein.common.i18n.ResourceBundleFactory;

public class ExoResourceBundleFactory
implements ResourceBundleFactory {
    private final ClassLoader classLoader;
    private final String baseName;

    public ExoResourceBundleFactory(ClassLoader classLoader, String baseName) {
        this.classLoader = classLoader;
        this.baseName = baseName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceBundle getBundle(Locale locale) throws IllegalArgumentException {
        if (locale == null) {
            throw new IllegalArgumentException();
        }
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        try {
            ResourceBundleService resourceBundleService;
            Thread.currentThread().setContextClassLoader(this.classLoader);
            PortalContainer portalContainer = PortalContainer.getInstance();
            if (portalContainer != null && (resourceBundleService = (ResourceBundleService)portalContainer.getComponentInstance(ResourceBundleService.class)) != null) {
                String[] portalBundles = resourceBundleService.getSharedResourceBundleNames();
                if (this.baseName != null) {
                    String[] bundles = new String[portalBundles.length + 1];
                    System.arraycopy(portalBundles, 0, bundles, 0, portalBundles.length);
                    bundles[portalBundles.length] = this.baseName;
                    portalBundles = bundles;
                }
                ResourceBundle resourceBundle = resourceBundleService.getResourceBundle(portalBundles, locale);
                return resourceBundle;
            }
            if (this.baseName != null) {
                ResourceBundle resourceBundle = ResourceBundle.getBundle(this.baseName, locale, this.classLoader);
                return resourceBundle;
            }
        }
        catch (Exception exception) {
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCL);
        }
        return null;
    }
}

