/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.server.firewall;

import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpRequestDecorator;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.http.server.reactive.SslInfo;
import org.springframework.security.web.server.firewall.ServerExchangeRejectedException;
import org.springframework.security.web.server.firewall.ServerWebExchangeFirewall;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.ServerWebExchangeDecorator;
import reactor.core.publisher.Mono;

public class StrictServerWebExchangeFirewall
implements ServerWebExchangeFirewall {
    private static final Set<HttpMethod> ALLOW_ANY_HTTP_METHOD = Collections.emptySet();
    private static final String ENCODED_PERCENT = "%25";
    private static final String PERCENT = "%";
    private static final List<String> FORBIDDEN_ENCODED_PERIOD = Collections.unmodifiableList(Arrays.asList("%2e", "%2E"));
    private static final List<String> FORBIDDEN_SEMICOLON = Collections.unmodifiableList(Arrays.asList(";", "%3b", "%3B"));
    private static final List<String> FORBIDDEN_FORWARDSLASH = Collections.unmodifiableList(Arrays.asList("%2f", "%2F"));
    private static final List<String> FORBIDDEN_DOUBLE_FORWARDSLASH = Collections.unmodifiableList(Arrays.asList("//", "%2f%2f", "%2f%2F", "%2F%2f", "%2F%2F"));
    private static final List<String> FORBIDDEN_BACKSLASH = Collections.unmodifiableList(Arrays.asList("\\", "%5c", "%5C"));
    private static final List<String> FORBIDDEN_NULL = Collections.unmodifiableList(Arrays.asList("\u0000", "%00"));
    private static final List<String> FORBIDDEN_LF = Collections.unmodifiableList(Arrays.asList("\n", "%0a", "%0A"));
    private static final List<String> FORBIDDEN_CR = Collections.unmodifiableList(Arrays.asList("\r", "%0d", "%0D"));
    private static final List<String> FORBIDDEN_LINE_SEPARATOR = Collections.unmodifiableList(Arrays.asList("\u2028"));
    private static final List<String> FORBIDDEN_PARAGRAPH_SEPARATOR = Collections.unmodifiableList(Arrays.asList("\u2029"));
    private Set<String> encodedUrlBlocklist = new HashSet<String>();
    private Set<String> decodedUrlBlocklist = new HashSet<String>();
    private Set<HttpMethod> allowedHttpMethods = StrictServerWebExchangeFirewall.createDefaultAllowedHttpMethods();
    private Predicate<String> allowedHostnames = hostname -> true;
    private static final Pattern ASSIGNED_AND_NOT_ISO_CONTROL_PATTERN = Pattern.compile("[\\p{IsAssigned}&&[^\\p{IsControl}]]*");
    private static final Predicate<String> ASSIGNED_AND_NOT_ISO_CONTROL_PREDICATE = s -> ASSIGNED_AND_NOT_ISO_CONTROL_PATTERN.matcher((CharSequence)s).matches();
    private static final Pattern HEADER_VALUE_PATTERN = Pattern.compile("[\\p{IsAssigned}&&[[^\\p{IsControl}]||\\t]]*");
    private static final Predicate<String> HEADER_VALUE_PREDICATE = s -> s == null || HEADER_VALUE_PATTERN.matcher((CharSequence)s).matches();
    private Predicate<String> allowedHeaderNames = ALLOWED_HEADER_NAMES;
    public static final Predicate<String> ALLOWED_HEADER_NAMES = ASSIGNED_AND_NOT_ISO_CONTROL_PREDICATE;
    private Predicate<String> allowedHeaderValues = ALLOWED_HEADER_VALUES;
    public static final Predicate<String> ALLOWED_HEADER_VALUES = HEADER_VALUE_PREDICATE;
    private Predicate<String> allowedParameterNames = ALLOWED_PARAMETER_NAMES;
    public static final Predicate<String> ALLOWED_PARAMETER_NAMES = ASSIGNED_AND_NOT_ISO_CONTROL_PREDICATE;
    private Predicate<String> allowedParameterValues = ALLOWED_PARAMETER_VALUES;
    public static final Predicate<String> ALLOWED_PARAMETER_VALUES = value -> true;

    public StrictServerWebExchangeFirewall() {
        this.urlBlocklistsAddAll(FORBIDDEN_SEMICOLON);
        this.urlBlocklistsAddAll(FORBIDDEN_FORWARDSLASH);
        this.urlBlocklistsAddAll(FORBIDDEN_DOUBLE_FORWARDSLASH);
        this.urlBlocklistsAddAll(FORBIDDEN_BACKSLASH);
        this.urlBlocklistsAddAll(FORBIDDEN_NULL);
        this.urlBlocklistsAddAll(FORBIDDEN_LF);
        this.urlBlocklistsAddAll(FORBIDDEN_CR);
        this.encodedUrlBlocklist.add(ENCODED_PERCENT);
        this.encodedUrlBlocklist.addAll(FORBIDDEN_ENCODED_PERIOD);
        this.decodedUrlBlocklist.add(PERCENT);
        this.decodedUrlBlocklist.addAll(FORBIDDEN_LINE_SEPARATOR);
        this.decodedUrlBlocklist.addAll(FORBIDDEN_PARAGRAPH_SEPARATOR);
    }

    public Set<String> getEncodedUrlBlocklist() {
        return this.encodedUrlBlocklist;
    }

    public Set<String> getDecodedUrlBlocklist() {
        return this.decodedUrlBlocklist;
    }

    @Override
    public Mono<ServerWebExchange> getFirewalledExchange(ServerWebExchange exchange) {
        return Mono.fromCallable(() -> {
            ServerHttpRequest request = exchange.getRequest();
            this.rejectForbiddenHttpMethod(request);
            this.rejectedBlocklistedUrls(request);
            this.rejectedUntrustedHosts(request);
            if (!this.isNormalized(request)) {
                throw new ServerExchangeRejectedException("The request was rejected because the URL was not normalized");
            }
            exchange.getResponse().beforeCommit(() -> Mono.fromRunnable(() -> {
                ServerHttpResponse response = exchange.getResponse();
                HttpHeaders headers = response.getHeaders();
                for (Map.Entry header : headers.entrySet()) {
                    String headerName = (String)header.getKey();
                    List headerValues = (List)header.getValue();
                    for (String headerValue : headerValues) {
                        StrictServerWebExchangeFirewall.validateCrlf(headerName, headerValue);
                    }
                }
            }));
            return new StrictFirewallServerWebExchange(exchange);
        });
    }

    private static void validateCrlf(String name, String value) {
        Assert.isTrue((!StrictServerWebExchangeFirewall.hasCrlf(name) && !StrictServerWebExchangeFirewall.hasCrlf(value) ? 1 : 0) != 0, () -> "Invalid characters (CR/LF) in header " + name);
    }

    private static boolean hasCrlf(String value) {
        return value != null && (value.indexOf(10) != -1 || value.indexOf(13) != -1);
    }

    public void setUnsafeAllowAnyHttpMethod(boolean unsafeAllowAnyHttpMethod) {
        this.allowedHttpMethods = unsafeAllowAnyHttpMethod ? ALLOW_ANY_HTTP_METHOD : StrictServerWebExchangeFirewall.createDefaultAllowedHttpMethods();
    }

    public void setAllowedHttpMethods(Collection<HttpMethod> allowedHttpMethods) {
        Assert.notNull(allowedHttpMethods, (String)"allowedHttpMethods cannot be null");
        this.allowedHttpMethods = allowedHttpMethods != ALLOW_ANY_HTTP_METHOD ? new HashSet<HttpMethod>(allowedHttpMethods) : ALLOW_ANY_HTTP_METHOD;
    }

    public void setAllowSemicolon(boolean allowSemicolon) {
        if (allowSemicolon) {
            this.urlBlocklistsRemoveAll(FORBIDDEN_SEMICOLON);
        } else {
            this.urlBlocklistsAddAll(FORBIDDEN_SEMICOLON);
        }
    }

    public void setAllowUrlEncodedSlash(boolean allowUrlEncodedSlash) {
        if (allowUrlEncodedSlash) {
            this.urlBlocklistsRemoveAll(FORBIDDEN_FORWARDSLASH);
        } else {
            this.urlBlocklistsAddAll(FORBIDDEN_FORWARDSLASH);
        }
    }

    public void setAllowUrlEncodedDoubleSlash(boolean allowUrlEncodedDoubleSlash) {
        if (allowUrlEncodedDoubleSlash) {
            this.urlBlocklistsRemoveAll(FORBIDDEN_DOUBLE_FORWARDSLASH);
        } else {
            this.urlBlocklistsAddAll(FORBIDDEN_DOUBLE_FORWARDSLASH);
        }
    }

    public void setAllowUrlEncodedPeriod(boolean allowUrlEncodedPeriod) {
        if (allowUrlEncodedPeriod) {
            this.encodedUrlBlocklist.removeAll(FORBIDDEN_ENCODED_PERIOD);
        } else {
            this.encodedUrlBlocklist.addAll(FORBIDDEN_ENCODED_PERIOD);
        }
    }

    public void setAllowBackSlash(boolean allowBackSlash) {
        if (allowBackSlash) {
            this.urlBlocklistsRemoveAll(FORBIDDEN_BACKSLASH);
        } else {
            this.urlBlocklistsAddAll(FORBIDDEN_BACKSLASH);
        }
    }

    public void setAllowNull(boolean allowNull) {
        if (allowNull) {
            this.urlBlocklistsRemoveAll(FORBIDDEN_NULL);
        } else {
            this.urlBlocklistsAddAll(FORBIDDEN_NULL);
        }
    }

    public void setAllowUrlEncodedPercent(boolean allowUrlEncodedPercent) {
        if (allowUrlEncodedPercent) {
            this.encodedUrlBlocklist.remove(ENCODED_PERCENT);
            this.decodedUrlBlocklist.remove(PERCENT);
        } else {
            this.encodedUrlBlocklist.add(ENCODED_PERCENT);
            this.decodedUrlBlocklist.add(PERCENT);
        }
    }

    public void setAllowUrlEncodedCarriageReturn(boolean allowUrlEncodedCarriageReturn) {
        if (allowUrlEncodedCarriageReturn) {
            this.urlBlocklistsRemoveAll(FORBIDDEN_CR);
        } else {
            this.urlBlocklistsAddAll(FORBIDDEN_CR);
        }
    }

    public void setAllowUrlEncodedLineFeed(boolean allowUrlEncodedLineFeed) {
        if (allowUrlEncodedLineFeed) {
            this.urlBlocklistsRemoveAll(FORBIDDEN_LF);
        } else {
            this.urlBlocklistsAddAll(FORBIDDEN_LF);
        }
    }

    public void setAllowUrlEncodedParagraphSeparator(boolean allowUrlEncodedParagraphSeparator) {
        if (allowUrlEncodedParagraphSeparator) {
            this.decodedUrlBlocklist.removeAll(FORBIDDEN_PARAGRAPH_SEPARATOR);
        } else {
            this.decodedUrlBlocklist.addAll(FORBIDDEN_PARAGRAPH_SEPARATOR);
        }
    }

    public void setAllowUrlEncodedLineSeparator(boolean allowUrlEncodedLineSeparator) {
        if (allowUrlEncodedLineSeparator) {
            this.decodedUrlBlocklist.removeAll(FORBIDDEN_LINE_SEPARATOR);
        } else {
            this.decodedUrlBlocklist.addAll(FORBIDDEN_LINE_SEPARATOR);
        }
    }

    public void setAllowedHeaderNames(Predicate<String> allowedHeaderNames) {
        Assert.notNull(allowedHeaderNames, (String)"allowedHeaderNames cannot be null");
        this.allowedHeaderNames = allowedHeaderNames;
    }

    public void setAllowedHeaderValues(Predicate<String> allowedHeaderValues) {
        Assert.notNull(allowedHeaderValues, (String)"allowedHeaderValues cannot be null");
        this.allowedHeaderValues = allowedHeaderValues;
    }

    public void setAllowedParameterNames(Predicate<String> allowedParameterNames) {
        Assert.notNull(allowedParameterNames, (String)"allowedParameterNames cannot be null");
        this.allowedParameterNames = allowedParameterNames;
    }

    public void setAllowedParameterValues(Predicate<String> allowedParameterValues) {
        Assert.notNull(allowedParameterValues, (String)"allowedParameterValues cannot be null");
        this.allowedParameterValues = allowedParameterValues;
    }

    public void setAllowedHostnames(Predicate<String> allowedHostnames) {
        Assert.notNull(allowedHostnames, (String)"allowedHostnames cannot be null");
        this.allowedHostnames = allowedHostnames;
    }

    private void urlBlocklistsAddAll(Collection<String> values) {
        this.encodedUrlBlocklist.addAll(values);
        this.decodedUrlBlocklist.addAll(values);
    }

    private void urlBlocklistsRemoveAll(Collection<String> values) {
        this.encodedUrlBlocklist.removeAll(values);
        this.decodedUrlBlocklist.removeAll(values);
    }

    private void rejectNonPrintableAsciiCharactersInFieldName(String toCheck, String propertyName) {
        if (!StrictServerWebExchangeFirewall.containsOnlyPrintableAsciiCharacters(toCheck)) {
            throw new ServerExchangeRejectedException(String.format("The %s was rejected because it can only contain printable ASCII characters.", propertyName));
        }
    }

    private void rejectForbiddenHttpMethod(ServerHttpRequest request) {
        if (this.allowedHttpMethods == ALLOW_ANY_HTTP_METHOD) {
            return;
        }
        if (!this.allowedHttpMethods.contains(request.getMethod())) {
            throw new ServerExchangeRejectedException("The request was rejected because the HTTP method \"" + String.valueOf(request.getMethod()) + "\" was not included within the list of allowed HTTP methods " + String.valueOf(this.allowedHttpMethods));
        }
    }

    private void rejectedBlocklistedUrls(ServerHttpRequest request) {
        for (String forbidden : this.encodedUrlBlocklist) {
            if (!StrictServerWebExchangeFirewall.encodedUrlContains(request, forbidden)) continue;
            throw new ServerExchangeRejectedException("The request was rejected because the URL contained a potentially malicious String \"" + forbidden + "\"");
        }
        for (String forbidden : this.decodedUrlBlocklist) {
            if (!StrictServerWebExchangeFirewall.decodedUrlContains(request, forbidden)) continue;
            throw new ServerExchangeRejectedException("The request was rejected because the URL contained a potentially malicious String \"" + forbidden + "\"");
        }
    }

    private void rejectedUntrustedHosts(ServerHttpRequest request) {
        String hostName = request.getURI().getHost();
        if (hostName != null && !this.allowedHostnames.test(hostName)) {
            throw new ServerExchangeRejectedException("The request was rejected because the domain " + hostName + " is untrusted.");
        }
    }

    private static Set<HttpMethod> createDefaultAllowedHttpMethods() {
        HashSet<HttpMethod> result = new HashSet<HttpMethod>();
        result.add(HttpMethod.DELETE);
        result.add(HttpMethod.GET);
        result.add(HttpMethod.HEAD);
        result.add(HttpMethod.OPTIONS);
        result.add(HttpMethod.PATCH);
        result.add(HttpMethod.POST);
        result.add(HttpMethod.PUT);
        return result;
    }

    private boolean isNormalized(ServerHttpRequest request) {
        if (!StrictServerWebExchangeFirewall.isNormalized(request.getPath().value())) {
            return false;
        }
        if (!StrictServerWebExchangeFirewall.isNormalized(request.getURI().getRawPath())) {
            return false;
        }
        return StrictServerWebExchangeFirewall.isNormalized(request.getURI().getPath());
    }

    private void validateAllowedHeaderName(String headerNames) {
        if (!this.allowedHeaderNames.test(headerNames)) {
            throw new ServerExchangeRejectedException("The request was rejected because the header name \"" + headerNames + "\" is not allowed.");
        }
    }

    private void validateAllowedHeaderValue(Object key, String value) {
        if (!this.allowedHeaderValues.test(value)) {
            throw new ServerExchangeRejectedException("The request was rejected because the header: \"" + String.valueOf(key) + " \" has a value \"" + value + "\" that is not allowed.");
        }
    }

    private void validateAllowedParameterName(String name) {
        if (!this.allowedParameterNames.test(name)) {
            throw new ServerExchangeRejectedException("The request was rejected because the parameter name \"" + name + "\" is not allowed.");
        }
    }

    private void validateAllowedParameterValue(String name, String value) {
        if (!this.allowedParameterValues.test(value)) {
            throw new ServerExchangeRejectedException("The request was rejected because the parameter: \"" + name + " \" has a value \"" + value + "\" that is not allowed.");
        }
    }

    private static boolean encodedUrlContains(ServerHttpRequest request, String value) {
        if (StrictServerWebExchangeFirewall.valueContains(request.getPath().value(), value)) {
            return true;
        }
        return StrictServerWebExchangeFirewall.valueContains(request.getURI().getRawPath(), value);
    }

    private static boolean decodedUrlContains(ServerHttpRequest request, String value) {
        return StrictServerWebExchangeFirewall.valueContains(request.getURI().getPath(), value);
    }

    private static boolean containsOnlyPrintableAsciiCharacters(String uri) {
        if (uri == null) {
            return true;
        }
        int length = uri.length();
        for (int i = 0; i < length; ++i) {
            char ch = uri.charAt(i);
            if (ch >= ' ' && ch <= '~') continue;
            return false;
        }
        return true;
    }

    private static boolean valueContains(String value, String contains) {
        return value != null && value.contains(contains);
    }

    private static boolean isNormalized(String path) {
        if (path == null) {
            return true;
        }
        int i = path.length();
        while (i > 0) {
            int slashIndex = path.lastIndexOf(47, i - 1);
            int gap = i - slashIndex;
            if (gap == 2 && path.charAt(slashIndex + 1) == '.') {
                return false;
            }
            if (gap == 3 && path.charAt(slashIndex + 1) == '.' && path.charAt(slashIndex + 2) == '.') {
                return false;
            }
            i = slashIndex;
        }
        return true;
    }

    private final class StrictFirewallServerWebExchange
    extends ServerWebExchangeDecorator {
        private StrictFirewallServerWebExchange(ServerWebExchange delegate) {
            super(delegate);
        }

        public ServerHttpRequest getRequest() {
            return new StrictFirewallHttpRequest(super.getRequest());
        }

        private final class StrictFirewallHttpRequest
        extends ServerHttpRequestDecorator {
            private StrictFirewallHttpRequest(ServerHttpRequest delegate) {
                super(delegate);
            }

            public HttpHeaders getHeaders() {
                return new StrictFirewallHttpHeaders(super.getHeaders());
            }

            public MultiValueMap<String, String> getQueryParams() {
                MultiValueMap queryParams = super.getQueryParams();
                for (Map.Entry paramEntry : queryParams.entrySet()) {
                    String paramName = (String)paramEntry.getKey();
                    StrictServerWebExchangeFirewall.this.validateAllowedParameterName(paramName);
                    for (String paramValue : (List)paramEntry.getValue()) {
                        StrictServerWebExchangeFirewall.this.validateAllowedParameterValue(paramName, paramValue);
                    }
                }
                return queryParams;
            }

            public ServerHttpRequest.Builder mutate() {
                return new StrictFirewallBuilder(super.mutate());
            }

            private final class StrictFirewallHttpHeaders
            extends HttpHeaders {
                private StrictFirewallHttpHeaders(HttpHeaders delegate) {
                    super((MultiValueMap)delegate);
                }

                public String getFirst(String headerName) {
                    StrictServerWebExchangeFirewall.this.validateAllowedHeaderName(headerName);
                    String headerValue = super.getFirst(headerName);
                    StrictServerWebExchangeFirewall.this.validateAllowedHeaderValue(headerName, headerValue);
                    return headerValue;
                }

                public List<String> get(Object key) {
                    List headerValues;
                    if (key instanceof String) {
                        String headerName = (String)key;
                        StrictServerWebExchangeFirewall.this.validateAllowedHeaderName(headerName);
                    }
                    if ((headerValues = super.get(key)) == null) {
                        return headerValues;
                    }
                    for (String headerValue : headerValues) {
                        StrictServerWebExchangeFirewall.this.validateAllowedHeaderValue(key, headerValue);
                    }
                    return headerValues;
                }

                public Set<String> keySet() {
                    Set headerNames = super.keySet();
                    for (String headerName : headerNames) {
                        StrictServerWebExchangeFirewall.this.validateAllowedHeaderName(headerName);
                    }
                    return headerNames;
                }
            }

            private final class StrictFirewallBuilder
            implements ServerHttpRequest.Builder {
                private final ServerHttpRequest.Builder delegate;

                private StrictFirewallBuilder(ServerHttpRequest.Builder delegate) {
                    this.delegate = delegate;
                }

                public ServerHttpRequest.Builder method(HttpMethod httpMethod) {
                    return new StrictFirewallBuilder(this.delegate.method(httpMethod));
                }

                public ServerHttpRequest.Builder uri(URI uri) {
                    return new StrictFirewallBuilder(this.delegate.uri(uri));
                }

                public ServerHttpRequest.Builder path(String path) {
                    return new StrictFirewallBuilder(this.delegate.path(path));
                }

                public ServerHttpRequest.Builder contextPath(String contextPath) {
                    return new StrictFirewallBuilder(this.delegate.contextPath(contextPath));
                }

                public ServerHttpRequest.Builder header(String headerName, String ... headerValues) {
                    return new StrictFirewallBuilder(this.delegate.header(headerName, headerValues));
                }

                public ServerHttpRequest.Builder headers(Consumer<HttpHeaders> headersConsumer) {
                    return new StrictFirewallBuilder(this.delegate.headers(headersConsumer));
                }

                public ServerHttpRequest.Builder sslInfo(SslInfo sslInfo) {
                    return new StrictFirewallBuilder(this.delegate.sslInfo(sslInfo));
                }

                public ServerHttpRequest.Builder remoteAddress(InetSocketAddress remoteAddress) {
                    return new StrictFirewallBuilder(this.delegate.remoteAddress(remoteAddress));
                }

                public ServerHttpRequest build() {
                    return new StrictFirewallHttpRequest(this.delegate.build());
                }
            }
        }
    }
}

