/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.twitter.gamification.rest;

import io.meeds.twitter.gamification.model.TwitterAccount;
import io.meeds.twitter.gamification.rest.builder.TwitterAccountBuilder;
import io.meeds.twitter.gamification.rest.model.TwitterAccountRestEntity;
import io.meeds.twitter.gamification.service.TwitterConsumerService;
import io.meeds.twitter.gamification.service.TwitterService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.PagedModel;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"accounts"})
@Tag(name="accounts", description="Manage and access twitter watched accounts")
public class TwitterAccountRest {
    @Autowired
    private TwitterService twitterService;
    @Autowired
    private TwitterConsumerService twitterConsumerService;

    @GetMapping
    @Secured(value={"users"})
    @Operation(summary="Retrieves the list of twitter watched accounts", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public PagedModel<EntityModel<TwitterAccountRestEntity>> getWatchedAccounts(HttpServletRequest request, Pageable pageable, PagedResourcesAssembler<TwitterAccountRestEntity> assembler) {
        try {
            Page<TwitterAccountRestEntity> twitterAccountRestEntities = this.getTwitterAccountRestEntities(request.getRemoteUser(), pageable);
            return assembler.toModel(twitterAccountRestEntities);
        }
        catch (IllegalAccessException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, e.getMessage());
        }
    }

    @GetMapping(path={"{accountId}"})
    @Secured(value={"users"})
    @Operation(summary="Retrieves a twitter watched account by its technical identifier", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="404", description="Not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    public TwitterAccount getWatchedAccountById(HttpServletRequest request, @Parameter(description="Account technical identifier", required=true) @PathVariable(value="accountId") long accountId) {
        if (accountId == 0L) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Account Id must be not null");
        }
        try {
            return this.twitterService.getTwitterAccountById(accountId, request.getRemoteUser());
        }
        catch (IllegalArgumentException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, e.getMessage());
        }
        catch (ObjectNotFoundException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, e.getMessage());
        }
    }

    @PostMapping
    @Secured(value={"users"})
    @Operation(summary="Create a watched Twitter account.", description="Create a watched Twitter account.", method="POST")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public void createWatchedAccount(HttpServletRequest request, @Parameter(description="Twitter username", required=true) @RequestParam(value="twitterUsername") String twitterUsername) {
        if (StringUtils.isBlank((CharSequence)twitterUsername)) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "'twitterUsername' parameter is mandatory");
        }
        try {
            this.twitterService.addTwitterAccount(twitterUsername, request.getRemoteUser());
        }
        catch (IllegalAccessException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, e.getMessage());
        }
        catch (ObjectAlreadyExistsException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, e.getMessage());
        }
        catch (ObjectNotFoundException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, e.getMessage());
        }
    }

    @DeleteMapping(path={"{accountId}"})
    @Secured(value={"users"})
    @Operation(summary="Deletes watched Twitter account.", description="Deletes watched Twitter account.", method="DELETE")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Bad request"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public void deleteWatchedAccount(HttpServletRequest request, @Parameter(description="Twitter account id", required=true) @PathVariable(value="accountId") long accountId) {
        try {
            this.twitterService.deleteTwitterAccount(accountId, request.getRemoteUser());
        }
        catch (IllegalAccessException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, e.getMessage());
        }
        catch (ObjectNotFoundException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, e.getMessage());
        }
    }

    private Page<TwitterAccountRestEntity> getTwitterAccountRestEntities(String username, Pageable pageable) throws IllegalAccessException {
        Page<TwitterAccount> twitterAccounts = this.twitterService.getTwitterAccounts(username, pageable);
        return TwitterAccountBuilder.toRestEntities(this.twitterService, this.twitterConsumerService, twitterAccounts);
    }
}

