/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.api.site;

import java.util.EnumSet;
import org.gatein.api.common.Filter;
import org.gatein.api.common.Pagination;
import org.gatein.api.common.Sorting;
import org.gatein.api.internal.Parameters;
import org.gatein.api.site.Site;
import org.gatein.api.site.SiteType;

public class SiteQuery {
    private final EnumSet<SiteType> siteTypes;
    private final boolean includeEmptySites;
    private final Filter<Site> filter;
    private final Pagination pagination;
    private final Sorting<Site> sorting;

    private SiteQuery(EnumSet<SiteType> siteTypes, boolean includeEmptySites, Filter<Site> filter, Pagination pagination, Sorting<Site> sorting) {
        this.siteTypes = siteTypes;
        this.includeEmptySites = includeEmptySites;
        this.filter = filter;
        this.pagination = pagination;
        this.sorting = sorting;
    }

    public EnumSet<SiteType> getSiteTypes() {
        return this.siteTypes;
    }

    public boolean isIncludeEmptySites() {
        return this.includeEmptySites;
    }

    public Filter<Site> getFilter() {
        return this.filter;
    }

    public Sorting<Site> getSorting() {
        return this.sorting;
    }

    public Pagination getPagination() {
        return this.pagination;
    }

    public SiteQuery nextPage() {
        return new Builder().from(this).withNextPage().build();
    }

    public SiteQuery previousPage() {
        return new Builder().from(this).withPreviousPage().build();
    }

    public static class Builder {
        public static final int DEFAULT_LIMIT = 15;
        public static final Pagination DEFAULT_PAGINATION = new Pagination(0, 15);
        public static final SiteType DEFAULT_SITE_TYPE = SiteType.SITE;
        private EnumSet<SiteType> siteTypes;
        private boolean emptySites;
        private Filter<Site> filter;
        private Pagination pagination = DEFAULT_PAGINATION;
        private Sorting<Site> sorting;

        public Builder() {
            this.siteTypes = EnumSet.of(DEFAULT_SITE_TYPE);
        }

        public Builder withSiteTypes(SiteType first, SiteType ... rest) {
            Parameters.requireNonNull(first, "first");
            return this.withSiteTypes(EnumSet.of(first, rest));
        }

        public Builder withSiteTypes(EnumSet<SiteType> siteTypes) {
            this.siteTypes = EnumSet.copyOf(Parameters.requireNonNull(siteTypes, "siteTypes"));
            return this;
        }

        public Builder withAllSiteTypes() {
            this.siteTypes = EnumSet.allOf(SiteType.class);
            return this;
        }

        public Builder includeEmptySites(boolean emptySites) {
            this.emptySites = emptySites;
            return this;
        }

        public Builder withPagination(int offset, int limit) {
            return this.withPagination(new Pagination(offset, limit));
        }

        public Builder withPagination(Pagination pagination) {
            this.pagination = pagination;
            return this;
        }

        public Builder withNextPage() {
            if (this.pagination != null) {
                this.pagination = this.pagination.getNext();
            }
            return this;
        }

        public Builder withPreviousPage() {
            if (this.pagination != null) {
                this.pagination = this.pagination.getPrevious();
            }
            return this;
        }

        public Builder withFilter(Filter<Site> filter) {
            this.filter = filter;
            return this;
        }

        public Builder withSorting(Sorting<Site> sorting) {
            this.sorting = sorting;
            return this;
        }

        public Builder ascending() {
            this.sorting = new Sorting(Sorting.Order.ascending);
            return this;
        }

        public Builder descending() {
            this.sorting = new Sorting(Sorting.Order.descending);
            return this;
        }

        public SiteQuery build() {
            if (this.siteTypes == null || this.siteTypes.isEmpty()) {
                this.siteTypes = EnumSet.of(SiteType.SITE);
            }
            return new SiteQuery(this.siteTypes, this.emptySites, this.filter, this.pagination, this.sorting);
        }

        public Builder from(SiteQuery query) {
            return new Builder().includeEmptySites(query.isIncludeEmptySites()).withSiteTypes(query.getSiteTypes()).withFilter(query.getFilter()).withPagination(query.getPagination()).withSorting(query.getSorting());
        }
    }
}

