/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.util.Iterator;
import java.util.Locale;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.FetchStyle;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.mapping.Any;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Selectable;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.metamodel.mapping.DiscriminatedAssociationModelPart;
import org.hibernate.metamodel.mapping.DiscriminatorMapping;
import org.hibernate.metamodel.mapping.DiscriminatorValueDetails;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.SelectablePath;
import org.hibernate.metamodel.mapping.internal.AnyDiscriminatorPart;
import org.hibernate.metamodel.mapping.internal.AnyKeyPart;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationHelper;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationProcess;
import org.hibernate.metamodel.mapping.internal.SingleAttributeIdentifierMapping;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchOptions;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.entity.internal.DiscriminatedEntityFetch;
import org.hibernate.sql.results.graph.entity.internal.DiscriminatedEntityResult;
import org.hibernate.type.AnyType;
import org.hibernate.type.BasicType;
import org.hibernate.type.MetaType;
import org.hibernate.type.descriptor.java.JavaType;

public class DiscriminatedAssociationMapping
implements MappingType,
FetchOptions {
    private final DiscriminatedAssociationModelPart modelPart;
    private final AnyDiscriminatorPart discriminatorPart;
    private final BasicValuedModelPart keyPart;
    private final JavaType<?> baseAssociationJtd;
    private final FetchTiming fetchTiming;
    private final SessionFactoryImplementor sessionFactory;

    public static DiscriminatedAssociationMapping from(NavigableRole containerRole, JavaType<?> baseAssociationJtd, DiscriminatedAssociationModelPart declaringModelPart, AnyType anyType, Any bootValueMapping, MappingModelCreationProcess creationProcess) {
        Dialect dialect = creationProcess.getCreationContext().getDialect();
        String tableName = MappingModelCreationHelper.getTableIdentifierExpression(bootValueMapping.getTable(), creationProcess);
        assert (bootValueMapping.getColumnSpan() == 2);
        Iterator<Selectable> columnIterator = bootValueMapping.getSelectables().iterator();
        assert (columnIterator.hasNext());
        Selectable metaSelectable = columnIterator.next();
        assert (columnIterator.hasNext());
        Selectable keySelectable = columnIterator.next();
        assert (!columnIterator.hasNext());
        assert (!metaSelectable.isFormula());
        assert (!keySelectable.isFormula());
        Column metaColumn = (Column)metaSelectable;
        Column keyColumn = (Column)keySelectable;
        SelectablePath parentSelectablePath = declaringModelPart.asAttributeMapping() != null ? MappingModelCreationHelper.getSelectablePath(declaringModelPart.asAttributeMapping().getDeclaringType()) : null;
        MetaType metaType = (MetaType)anyType.getDiscriminatorType();
        AnyDiscriminatorPart discriminatorPart = new AnyDiscriminatorPart(containerRole.append("{discriminator}"), declaringModelPart, tableName, metaColumn.getText(dialect), parentSelectablePath != null ? parentSelectablePath.append(metaColumn.getQuotedName(dialect)) : new SelectablePath(metaColumn.getQuotedName(dialect)), metaColumn.getCustomReadExpression(), metaColumn.getCustomWriteExpression(), metaColumn.getSqlType(), metaColumn.getLength(), metaColumn.getPrecision(), metaColumn.getScale(), bootValueMapping.isColumnInsertable(0), bootValueMapping.isColumnUpdateable(0), bootValueMapping.isPartitionKey(), (BasicType)metaType.getBaseType(), metaType.getDiscriminatorValuesToEntityNameMap(), creationProcess.getCreationContext().getSessionFactory().getMappingMetamodel());
        BasicType keyType = (BasicType)anyType.getIdentifierType();
        AnyKeyPart keyPart = new AnyKeyPart(containerRole.append("{key}"), declaringModelPart, tableName, keyColumn.getText(dialect), parentSelectablePath != null ? parentSelectablePath.append(keyColumn.getQuotedName(dialect)) : new SelectablePath(keyColumn.getQuotedName(dialect)), keyColumn.getCustomReadExpression(), keyColumn.getCustomWriteExpression(), keyColumn.getSqlType(), keyColumn.getLength(), keyColumn.getPrecision(), keyColumn.getScale(), bootValueMapping.isNullable(), bootValueMapping.isColumnInsertable(1), bootValueMapping.isColumnUpdateable(1), bootValueMapping.isPartitionKey(), keyType);
        return new DiscriminatedAssociationMapping(declaringModelPart, discriminatorPart, keyPart, baseAssociationJtd, bootValueMapping.isLazy() ? FetchTiming.DELAYED : FetchTiming.IMMEDIATE, creationProcess.getCreationContext().getSessionFactory());
    }

    public DiscriminatedAssociationMapping(DiscriminatedAssociationModelPart modelPart, AnyDiscriminatorPart discriminatorPart, BasicValuedModelPart keyPart, JavaType<?> baseAssociationJtd, FetchTiming fetchTiming, SessionFactoryImplementor sessionFactory) {
        this.modelPart = modelPart;
        this.discriminatorPart = discriminatorPart;
        this.keyPart = keyPart;
        this.baseAssociationJtd = baseAssociationJtd;
        this.fetchTiming = fetchTiming;
        this.sessionFactory = sessionFactory;
    }

    public DiscriminatedAssociationModelPart getModelPart() {
        return this.modelPart;
    }

    public DiscriminatorMapping getDiscriminatorPart() {
        return this.discriminatorPart;
    }

    public BasicValuedModelPart getKeyPart() {
        return this.keyPart;
    }

    public Object resolveDiscriminatorValueToEntityMapping(EntityMappingType entityMappingType) {
        DiscriminatorValueDetails details = this.discriminatorPart.getValueConverter().getDetailsForEntityName(entityMappingType.getEntityName());
        return details != null ? details.getValue() : null;
    }

    public EntityMappingType resolveDiscriminatorValueToEntityMapping(Object discriminatorValue) {
        DiscriminatorValueDetails details = this.discriminatorPart.getValueConverter().getDetailsForDiscriminatorValue(discriminatorValue);
        return details != null ? details.getIndicatedEntity() : null;
    }

    public <X, Y> int breakDownJdbcValues(int offset, X x, Y y, Object domainValue, ModelPart.JdbcValueBiConsumer<X, Y> valueConsumer, SharedSessionContractImplementor session) {
        if (domainValue == null) {
            valueConsumer.consume(offset, x, y, null, this.getDiscriminatorPart());
            valueConsumer.consume(offset + 1, x, y, null, this.getKeyPart());
            return this.getDiscriminatorPart().getJdbcTypeCount() + this.getKeyPart().getJdbcTypeCount();
        }
        EntityMappingType concreteMappingType = this.determineConcreteType(domainValue, session);
        Object discriminator = this.getModelPart().resolveDiscriminatorForEntityType(concreteMappingType);
        Object disassembledDiscriminator = this.getDiscriminatorPart().disassemble(discriminator, session);
        valueConsumer.consume(offset, x, y, disassembledDiscriminator, this.getDiscriminatorPart());
        EntityIdentifierMapping identifierMapping = concreteMappingType.getIdentifierMapping();
        Object identifier = identifierMapping.getIdentifier(domainValue);
        Object disassembledKey = this.getKeyPart().disassemble(identifier, session);
        valueConsumer.consume(offset + 1, x, y, disassembledKey, this.getKeyPart());
        return this.getDiscriminatorPart().getJdbcTypeCount() + this.getKeyPart().getJdbcTypeCount();
    }

    public <X, Y> int decompose(int offset, X x, Y y, Object domainValue, ModelPart.JdbcValueBiConsumer<X, Y> valueConsumer, SharedSessionContractImplementor session) {
        if (domainValue == null) {
            valueConsumer.consume(offset, x, y, null, this.getDiscriminatorPart());
            valueConsumer.consume(offset + 1, x, y, null, this.getKeyPart());
        } else {
            EntityMappingType concreteMappingType = this.determineConcreteType(domainValue, session);
            Object discriminator = this.getModelPart().resolveDiscriminatorForEntityType(concreteMappingType);
            this.getDiscriminatorPart().decompose(discriminator, offset, x, y, valueConsumer, session);
            EntityIdentifierMapping identifierMapping = concreteMappingType.getIdentifierMapping();
            Object identifier = identifierMapping.getIdentifier(domainValue);
            this.getKeyPart().decompose(identifier, offset + 1, x, y, valueConsumer, session);
        }
        return this.getDiscriminatorPart().getJdbcTypeCount() + this.getKeyPart().getJdbcTypeCount();
    }

    private EntityMappingType determineConcreteType(Object entity, SharedSessionContractImplementor session) {
        String entityName = session == null ? this.sessionFactory.bestGuessEntityName(entity) : session.bestGuessEntityName(entity);
        return this.sessionFactory.getRuntimeMetamodels().getEntityMappingType(entityName);
    }

    public ModelPart findSubPart(String name, EntityMappingType treatTarget) {
        if ("{discriminator}".equals(name)) {
            return this.getDiscriminatorPart();
        }
        if ("{key}".equals(name)) {
            return this.getKeyPart();
        }
        if (treatTarget != null) {
            this.ensureMapped(treatTarget);
            return this.resolveAssociatedSubPart(name, treatTarget);
        }
        return this.discriminatorPart.getValueConverter().fromValueDetails(detail -> {
            try {
                ModelPart subPart = this.resolveAssociatedSubPart(name, detail.getIndicatedEntity());
                if (subPart != null) {
                    return subPart;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        });
    }

    private ModelPart resolveAssociatedSubPart(String name, EntityMappingType entityMapping) {
        String idAttrName;
        EntityIdentifierMapping identifierMapping = entityMapping.getIdentifierMapping();
        if (identifierMapping.getPartName().equals(name)) {
            return this.getKeyPart();
        }
        if (identifierMapping instanceof SingleAttributeIdentifierMapping && (idAttrName = identifierMapping.getAttributeName()).equals(name)) {
            return this.getKeyPart();
        }
        return entityMapping.findSubPart(name);
    }

    private void ensureMapped(EntityMappingType treatTarget) {
        assert (treatTarget != null);
        DiscriminatorValueDetails details = this.discriminatorPart.getValueConverter().getDetailsForEntityName(treatTarget.getEntityName());
        if (details != null) {
            return;
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "Treat-target [`%s`] is not not an entity mapped by ANY value : %s", treatTarget.getEntityName(), this.modelPart.getNavigableRole()));
    }

    public MappingType getPartMappingType() {
        return this;
    }

    public JavaType<?> getJavaType() {
        return this.baseAssociationJtd;
    }

    @Override
    public JavaType<?> getMappedJavaType() {
        return this.baseAssociationJtd;
    }

    @Override
    public FetchStyle getStyle() {
        return FetchStyle.SELECT;
    }

    @Override
    public FetchTiming getTiming() {
        return this.fetchTiming;
    }

    public Fetch generateFetch(FetchParent fetchParent, NavigablePath fetchablePath, FetchTiming fetchTiming, boolean selected, String resultVariable, DomainResultCreationState creationState) {
        return new DiscriminatedEntityFetch(fetchablePath, this.baseAssociationJtd, this.modelPart, fetchTiming, fetchParent, creationState);
    }

    public <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, DomainResultCreationState creationState) {
        return new DiscriminatedEntityResult(navigablePath, this.baseAssociationJtd, this.modelPart, resultVariable, creationState);
    }
}

