/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.common.net.media;

public final class TypeDef {
    public static final TypeDef TEXT = new TypeDef("text", "", false);
    public static final TypeDef IMAGE = new TypeDef("image", "", false);
    public static final TypeDef AUDIO = new TypeDef("audio", "", false);
    public static final TypeDef VIDEO = new TypeDef("video", "", false);
    public static final TypeDef APPLICATION = new TypeDef("application", "", false);
    public static final TypeDef MULTIPART = new TypeDef("multipart", "", true);
    public static final TypeDef MESSAGE = new TypeDef("message", "", true);
    private final String name;
    private final String description;
    private final boolean composite;
    private final String toString;

    public static TypeDef create(String typeName) throws IllegalArgumentException {
        if (typeName == null) {
            throw new IllegalArgumentException("no null type name accepted");
        }
        if (TypeDef.TEXT.name.equalsIgnoreCase(typeName)) {
            return TEXT;
        }
        if (TypeDef.APPLICATION.name.equalsIgnoreCase(typeName)) {
            return APPLICATION;
        }
        if (TypeDef.MULTIPART.name.equalsIgnoreCase(typeName)) {
            return MULTIPART;
        }
        if (TypeDef.IMAGE.name.equalsIgnoreCase(typeName)) {
            return IMAGE;
        }
        if (TypeDef.AUDIO.name.equalsIgnoreCase(typeName)) {
            return AUDIO;
        }
        if (TypeDef.VIDEO.name.equalsIgnoreCase(typeName)) {
            return VIDEO;
        }
        if (TypeDef.MESSAGE.name.equalsIgnoreCase(typeName)) {
            return MESSAGE;
        }
        return null;
    }

    private TypeDef(String name, String description, boolean composite) {
        this.name = name;
        this.description = description;
        this.composite = composite;
        this.toString = "TypeDef[" + name + "]";
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isComposite() {
        return this.composite;
    }

    public boolean isDiscrete() {
        return !this.composite;
    }

    public String toString() {
        return this.toString;
    }
}

