/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.navigation;

import org.exoplatform.portal.mop.navigation.NodeContext;
import org.exoplatform.portal.mop.navigation.NodeState;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.portal.mop.navigation.VisitMode;

class FederatingVisitor<N>
implements Scope.Visitor {
    private final Scope.Visitor visitor;
    private final NodeContext<N> federationRoot;
    private final int federationDepth;
    private final Scope federatedScope;
    private Scope.Visitor federated;

    FederatingVisitor(Scope.Visitor visitor, NodeContext<N> federationRoot, Scope federatedScope) {
        this.visitor = visitor;
        this.federationRoot = federationRoot;
        this.federatedScope = federatedScope;
        this.federated = null;
        this.federationDepth = federationRoot.getDepth(federationRoot.tree.root);
    }

    @Override
    public VisitMode enter(int depth, String id, String name, NodeState state) {
        if (this.federationRoot.handle.equals(id)) {
            this.federated = this.federatedScope.get();
        }
        VisitMode visit = this.federated != null ? this.federated.enter(depth - this.federationDepth, id, name, state) : VisitMode.NO_CHILDREN;
        VisitMode override = this.visitor.enter(depth, id, name, state);
        if (override == VisitMode.ALL_CHILDREN) {
            visit = VisitMode.ALL_CHILDREN;
        }
        return visit;
    }

    @Override
    public void leave(int depth, String id, String name, NodeState state) {
        if (this.federationRoot.handle.equals(id)) {
            this.federated = null;
        }
        if (this.federated != null) {
            this.federated.leave(depth - this.federationDepth, id, name, state);
        }
    }
}

