/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.common;

import io.meeds.social.common.ContainerStartableService;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.servlet.ServletContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import lombok.Generated;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;

@Service
public class ContainerStartupTaskService
implements ApplicationContextAware {
    @Generated
    private final Object $lock = new Object[0];
    private static final Log LOG = ExoLogger.getLogger(ContainerStartupTaskService.class);
    @Autowired
    private PortalContainer container;
    private ApplicationContext applicationContext;
    @Value(value="${meeds.startup.threadCount:5}")
    private int threadCount;
    private ExecutorService executorService;
    private Map<String, List<Runnable>> tasksById = new ConcurrentHashMap<String, List<Runnable>>();

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @PostConstruct
    public void init() {
        List serviceList = this.applicationContext.getBeansOfType(ContainerStartableService.class).values().stream().sorted((a, b) -> a.getOrder() - b.getOrder()).toList();
        serviceList.forEach(s -> this.addTask(s.getId(), s::start));
        LOG.info("Run {} startup Tasks in asynchronous threads", new Object[]{serviceList.size()});
        this.executorService = Executors.newVirtualThreadPerTaskExecutor();
        if (this.container.isStarted()) {
            CompletableFuture.runAsync(this::start, this.executorService);
        } else {
            PortalContainer.addInitTask((ServletContext)this.container.getPortalContext(), (RootContainer.PortalContainerInitTask)new RootContainer.PortalContainerPostCreateTask(){

                public void execute(ServletContext context, PortalContainer portalContainer) {
                    CompletableFuture.runAsync(ContainerStartupTaskService.this::start, ContainerStartupTaskService.this.executorService);
                }
            });
        }
    }

    public void start() {
        LOG.info((Object)"Run startup Tasks in dedicated threads");
        long start = System.currentTimeMillis();
        this.tasksById.entrySet().parallelStream().forEach(entry -> ((List)entry.getValue()).stream().forEachOrdered(r -> {
            long startup = System.currentTimeMillis();
            LOG.info("Startup Asynchronous Task with chain id {}", new Object[]{entry.getKey()});
            try {
                Future<?> future = this.executorService.submit((Runnable)r);
                future.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                LOG.warn((Object)"Error while executing an asynchronous startup task ", (Throwable)e);
            }
            LOG.info("Asynchronous Task with chain id {} finished within {}ms", new Object[]{entry.getKey(), System.currentTimeMillis() - startup});
        }));
        LOG.info("Startup Tasks finished within {}ms", new Object[]{System.currentTimeMillis() - start});
        this.tasksById.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTask(String id, Runnable task) {
        Object object = this.$lock;
        synchronized (object) {
            this.tasksById.computeIfAbsent(id, k -> Collections.synchronizedList(new ArrayList())).add(task);
        }
    }

    @PreDestroy
    public void stop() {
        this.executorService.shutdown();
    }
}

