/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.content.news.plugin;

import io.meeds.content.news.model.News;
import io.meeds.content.news.service.NewsService;
import io.meeds.portal.plugin.AclPlugin;
import jakarta.annotation.PostConstruct;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.security.Identity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NewsAclPlugin
implements AclPlugin {
    private static final String OBJECT_TYPE = "news";
    @Autowired
    private PortalContainer container;
    @Autowired
    private NewsService newsService;

    @PostConstruct
    public void init() {
        ((UserACL)this.container.getComponentInstanceOfType(UserACL.class)).addAclPlugin((AclPlugin)this);
    }

    public String getObjectType() {
        return OBJECT_TYPE;
    }

    public boolean hasPermission(String objectId, String permissionType, Identity identity) {
        News news = this.newsService.getNewsArticleById(objectId);
        if (news == null) {
            return false;
        }
        return switch (permissionType) {
            case "VIEW" -> this.newsService.canViewNews(news, identity == null ? null : identity.getUserId());
            case "EDIT" -> this.newsService.canEditNews(news, identity == null ? null : identity.getUserId());
            default -> false;
        };
    }
}

