/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.resource.rest;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.portal.resource.SkinConfig;
import org.exoplatform.portal.resource.SkinService;
import org.exoplatform.services.resources.Orientation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"/skins"})
@Tag(name="/skins", description="Retrieve Skin Resources")
public class SkinRest {
    @Autowired
    private SkinService skinService;

    @GetMapping(value={"{skinType}/{skinId}"})
    @Operation(summary="Redirects to a skin URL which is identified by its id/name", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="404", description="Not Found"), @ApiResponse(responseCode="302", description="Found with redirection")})
    public void getSkin(HttpServletResponse response, @Parameter(description="Skin type: portlet or portal", required=true) @PathVariable(value="skinType") String skinType, @Parameter(description="Skin identifier: portal skin name or portlet skin name", required=true) @PathVariable(value="skinId") String skinId, @Parameter(description="Skin Name (optional): skin name", required=false) @RequestParam(name="skinName", required=false) String skinName, @Parameter(description="Orientation: LT or RT", required=false) @RequestParam(name="orientation", defaultValue="LT", required=false) Orientation orientation) throws IOException {
        SkinConfig skin = this.getSkinConfig(skinType, skinId, skinName);
        if (skin == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, String.format("Skin with name %s/%s wasn't found", skinType, skinId));
        }
        String url = skin.createURL().toString(orientation);
        response.sendRedirect(url);
    }

    private SkinConfig getSkinConfig(String skinType, String skinId, String skinName) {
        if (StringUtils.equals((CharSequence)skinType, (CharSequence)"portal")) {
            return this.skinService.getPortalSkin(skinId, skinName);
        }
        return this.skinService.getSkin(String.format("%s/%s", skinType, skinId), skinName);
    }
}

