/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.analytics.rest;

import io.meeds.analytics.api.service.AnalyticsService;
import io.meeds.analytics.model.chart.ChartAggregationResult;
import io.meeds.analytics.model.chart.ChartData;
import io.meeds.analytics.model.chart.ChartDataList;
import io.meeds.analytics.model.filter.aggregation.AnalyticsAggregationType;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"chart"})
@Tag(name="/analytics/rest/chart", description="Retrieve Analytics Chart Data")
public class AnalyticsChartRest {
    @Autowired
    private AnalyticsService analyticsService;

    @GetMapping
    @Secured(value={"analytics"})
    @Operation(summary="Retrieve Analytics two dimensions Chat Data", method="GET", description="This will compute a two dimensions matrix of data useful for chart display")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled")})
    public List<ChartAggregationResult> getChart(@Parameter(description="Collected Statistic Operations to consider in query", required=false) @RequestParam(name="operation", required=false) List<String> operations, @Parameter(description="Filtered field name", required=false) @RequestParam(name="fieldName", required=false) String fieldName, @Parameter(description="Filtered field values", required=false) @RequestParam(name="fieldValue", required=false) List<String> fieldValues, @Parameter(description="X Axis aggregation field", required=true) @RequestParam(value="xAggregationField") String xAggregationField, @Parameter(description="X Axis aggregation type: MAX, MIN, SUM, COUNT, CARDINALITY (COUNT Distinct), TERMS, DATA or HISTOGRAM", required=true) @RequestParam(value="xAggregationType") AnalyticsAggregationType xAggregationType, @Parameter(description="X Axis sort direction: asc or desc", required=false) @RequestParam(name="xAggregationSortDirection", required=false) String xAggregationSortDirection, @Parameter(description="Y Axis aggregation field", required=true) @RequestParam(value="yAggregationField") String yAggregationField, @Parameter(description="Y Axis aggregation type: MAX, MIN, SUM, COUNT, CARDINALITY (COUNT Distinct), TERMS, DATA or HISTOGRAM", required=true) @RequestParam(value="yAggregationType") AnalyticsAggregationType yAggregationType, @Parameter(description="Y Axis sort direction: asc or desc", required=true) @RequestParam(name="yAggregationSortDirection", required=false) String yAggregationSortDirection, @Parameter(description="Limit of x Axis results to retrieve", required=true) @RequestParam(value="limit") int limit) {
        ChartDataList chartData = this.analyticsService.getChart(operations, fieldName, fieldValues, xAggregationField, xAggregationType, xAggregationSortDirection, yAggregationField, yAggregationType, yAggregationSortDirection, limit);
        if (chartData != null && CollectionUtils.size((Object)chartData.getCharts()) == 1) {
            return ((ChartData)chartData.getCharts().getFirst()).getAggregationResults();
        }
        return Collections.emptyList();
    }
}

