/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.controller.router;

class BitStack {
    private Frame head;
    private Frame current = null;
    private int depth = 0;
    private int size = 0;

    BitStack() {
    }

    void init(int size) {
        if (this.depth > 0) {
            throw new IllegalStateException();
        }
        if (size < 0) {
            throw new IllegalArgumentException();
        }
        this.size = size;
    }

    void reset() {
        if (this.depth > 0) {
            throw new IllegalStateException();
        }
        this.size = 0;
    }

    void push() {
        if (this.current == null) {
            if (this.head == null) {
                this.head = new Frame();
            }
            this.current = this.head;
            ++this.depth;
        } else if (this.current.next == null) {
            Frame next;
            this.current.next = next = new Frame(this.current.bits, this.current.cardinality);
            next.previous = this.current;
            this.current = next;
            ++this.depth;
        } else {
            Frame next = this.current.next;
            next.bits = this.current.bits;
            next.cardinality = this.current.cardinality;
            this.current = next;
            ++this.depth;
        }
    }

    void pop() {
        if (this.depth == 0) {
            throw new IllegalStateException();
        }
        this.current = this.current.previous;
        --this.depth;
    }

    int getDepth() {
        return this.depth;
    }

    void set(int index) {
        if (index > 63) {
            throw new IllegalArgumentException("Index " + index + "  > 63 not allowed");
        }
        if (this.depth < 1) {
            throw new IllegalStateException();
        }
        if (index > this.size) {
            throw new IllegalArgumentException();
        }
        long pre = this.current.bits;
        this.current.bits |= 1L << index;
        if (this.current.bits != pre) {
            ++this.current.cardinality;
        }
    }

    boolean get(int index) {
        if (index > 63) {
            throw new IllegalArgumentException("Index " + index + "  > 63 not allowed");
        }
        if (this.depth < 1) {
            throw new IllegalStateException();
        }
        if (index > this.size) {
            throw new IllegalArgumentException();
        }
        return (this.current.bits & 1L << index) != 0L;
    }

    boolean isEmpty() {
        if (this.depth < 1) {
            throw new IllegalStateException();
        }
        return this.current.cardinality == this.size;
    }

    private static class Frame {
        private Frame previous = null;
        private Frame next = null;
        private long bits;
        private int cardinality;

        private Frame() {
            this(0L, 0);
        }

        private Frame(long bits, int cardinality) {
            this.bits = bits;
            this.cardinality = cardinality;
        }
    }
}

