/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.handler;

import jakarta.servlet.ServletConfig;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.url.PortalURLContext;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.SpaceAccessType;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.web.ControllerContext;
import org.exoplatform.web.WebAppController;
import org.exoplatform.web.WebRequestHandler;
import org.exoplatform.web.url.URLContext;
import org.exoplatform.web.url.URLFactoryService;
import org.exoplatform.web.url.navigation.NavigationResource;
import org.exoplatform.web.url.navigation.NodeURL;

public class ActivityAccessHandler
extends WebRequestHandler {
    public static final String PAGE_URI = "space-access";
    private IdentityManager identityManager;
    private ActivityManager activityManager;
    private SpaceService spaceService;
    private URLFactoryService urlFactoryService;
    private UserPortalConfigService userPortalConfigService;

    public void onInit(WebAppController controller, ServletConfig sConfig) throws Exception {
        super.onInit(controller, sConfig);
        PortalContainer container = PortalContainer.getInstance();
        this.spaceService = (SpaceService)container.getComponentInstanceOfType(SpaceService.class);
        this.identityManager = (IdentityManager)container.getComponentInstanceOfType(IdentityManager.class);
        this.activityManager = (ActivityManager)container.getComponentInstanceOfType(ActivityManager.class);
        this.urlFactoryService = (URLFactoryService)container.getComponentInstanceOfType(URLFactoryService.class);
        this.userPortalConfigService = (UserPortalConfigService)container.getComponentInstanceOfType(UserPortalConfigService.class);
    }

    public String getHandlerName() {
        return "activity-access";
    }

    protected boolean getRequiresLifeCycle() {
        return true;
    }

    public boolean execute(ControllerContext controllerContext) throws Exception {
        String username = controllerContext.getRequest().getRemoteUser();
        String idParameter = controllerContext.getRequest().getParameter("id");
        if (idParameter != null) {
            ExoSocialActivity activity = this.activityManager.getActivity(idParameter);
            Identity authenticatedUserIdentity = ConversationState.getCurrent().getIdentity();
            if (activity != null && !this.activityManager.isActivityViewable(activity, authenticatedUserIdentity)) {
                String spaceId;
                Space space;
                if (activity.isComment()) {
                    activity = this.activityManager.getActivity(activity.getParentId());
                }
                if ((space = this.spaceService.getSpaceById(spaceId = activity.getSpaceId())) == null || "hidden".equals(space.getVisibility())) {
                    return false;
                }
                if (username == null) {
                    return false;
                }
                this.processSpaceAccess(controllerContext, authenticatedUserIdentity.getUserId(), space);
                return true;
            }
        }
        return false;
    }

    private void processSpaceAccess(ControllerContext controllerContext, String remoteId, Space space) throws IOException {
        org.exoplatform.social.core.identity.model.Identity identity = this.identityManager.getOrCreateUserIdentity(remoteId);
        if (identity.isExternal() && (space == null || !this.spaceService.isInvitedUser(space, remoteId))) {
            controllerContext.getResponse().sendRedirect("/");
            return;
        }
        SpaceAccessType spaceAccessType = Arrays.stream(SpaceAccessType.values()).filter(accessType -> accessType.doCheck(remoteId, space)).findFirst().orElse(null);
        this.sendRedirect(controllerContext, spaceAccessType, space);
    }

    private void sendRedirect(ControllerContext controllerContext, SpaceAccessType type, Space space) throws IOException {
        HttpServletRequest request = controllerContext.getRequest();
        HttpSession session = request.getSession();
        session.setAttribute("social.accessed.space.type.key", (Object)type);
        if (space == null) {
            session.removeAttribute("social.accessed.space.prettyName.key");
            session.removeAttribute("social.accessed.space.displayName.key");
        } else {
            session.setAttribute("social.accessed.space.id.key", (Object)space.getId());
            session.setAttribute("social.accessed.space.prettyName.key", (Object)space.getDisplayName());
            session.setAttribute("social.accessed.space.displayName.key", (Object)space.getPrettyName());
            session.setAttribute("social.accessed.space.request.path.key", (Object)request.getRequestURI());
        }
        controllerContext.getResponse().sendRedirect(this.getURI(controllerContext, PAGE_URI));
    }

    private String getURI(ControllerContext controllerContext, String uri) {
        String portalName = this.userPortalConfigService.getMetaPortal();
        SiteKey siteKey = SiteKey.portal((String)portalName);
        NavigationResource resource = new NavigationResource(siteKey.getType(), siteKey.getName(), uri);
        NodeURL url = (NodeURL)this.urlFactoryService.newURL(NodeURL.TYPE, (URLContext)new PortalURLContext(controllerContext, siteKey));
        url.setAjax(Boolean.valueOf(false));
        url.setResource(resource);
        return url.toString();
    }

    private String getPageNotFoundSite(String username) {
        return StringUtils.isBlank((CharSequence)username) ? "public" : this.userPortalConfigService.getMetaPortal();
    }
}

