/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.TokenFilterBase;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterDefinition;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterDefinitionVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class JaStopTokenFilter
extends TokenFilterBase
implements TokenFilterDefinitionVariant {
    private final List<String> stopwords;
    public static final JsonpDeserializer<JaStopTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, JaStopTokenFilter::setupJaStopTokenFilterDeserializer);

    private JaStopTokenFilter(Builder builder) {
        super(builder);
        this.stopwords = ApiTypeHelper.unmodifiable(builder.stopwords);
    }

    public static JaStopTokenFilter of(Function<Builder, ObjectBuilder<JaStopTokenFilter>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenFilterDefinition.Kind _tokenFilterDefinitionKind() {
        return TokenFilterDefinition.Kind.JaStop;
    }

    public final List<String> stopwords() {
        return this.stopwords;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "ja_stop");
        super.serializeInternal(generator, mapper);
        if (ApiTypeHelper.isDefined(this.stopwords)) {
            generator.writeKey("stopwords");
            generator.writeStartArray();
            for (String item0 : this.stopwords) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    protected static void setupJaStopTokenFilterDeserializer(ObjectDeserializer<Builder> op) {
        TokenFilterBase.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::stopwords, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "stopwords");
        op.ignore("type");
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<JaStopTokenFilter> {
        @Nullable
        private List<String> stopwords;

        public final Builder stopwords(List<String> list) {
            this.stopwords = Builder._listAddAll(this.stopwords, list);
            return this;
        }

        public final Builder stopwords(String value, String ... values) {
            this.stopwords = Builder._listAdd(this.stopwords, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public JaStopTokenFilter build() {
            this._checkSingleUse();
            return new JaStopTokenFilter(this);
        }
    }
}

