/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.databind.service;

import io.meeds.social.databind.model.DatabindReport;
import io.meeds.social.databind.plugin.DatabindPlugin;
import io.meeds.social.databind.service.DatabindService;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.upload.UploadResource;
import org.exoplatform.upload.UploadService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class DatabindServiceImpl
implements DatabindService {
    private final Map<String, DatabindPlugin> dataPreferencePlugins = new ConcurrentHashMap<String, DatabindPlugin>();
    @Autowired
    private UploadService uploadService;

    public void addPlugin(DatabindPlugin plugin) {
        this.dataPreferencePlugins.put(plugin.getObjectType(), plugin);
    }

    public File serialize(String objectType, List<String> objectIds, String username) throws ObjectNotFoundException, IllegalAccessException {
        String safePrefix = (objectType.length() >= 3 ? objectType : "obj") + "_";
        File zipFile = File.createTempFile(safePrefix, ".zip");
        try (FileOutputStream fos = new FileOutputStream(zipFile);
             ZipOutputStream zipOutputStream = new ZipOutputStream(fos);){
            for (String objectId : objectIds) {
                for (DatabindPlugin plugin : this.dataPreferencePlugins.values()) {
                    if (!plugin.canHandleDatabind(objectType, objectId)) continue;
                    plugin.serialize(objectId, zipOutputStream, username);
                }
            }
            DatabindServiceImpl.addMetadataFile(zipOutputStream, objectType);
        }
        catch (IOException e) {
            throw new IllegalStateException("Error exporting template", e);
        }
        return zipFile;
    }

    @Async
    public CompletableFuture<DatabindReport> deserialize(String objectType, String uploadId, Map<String, String> params, String username) {
        if (StringUtils.isBlank((CharSequence)uploadId)) {
            throw new IllegalArgumentException("uploadId is mandatory");
        }
        UploadResource uploadResource = this.uploadService.getUploadResource(uploadId);
        if (uploadResource == null) {
            throw new IllegalStateException("Can't find uploaded resource with id : " + uploadId);
        }
        File zipFile = new File(uploadResource.getStoreLocation());
        if (!zipFile.exists()) {
            throw new IllegalArgumentException("ZIP file missing in upload folder.");
        }
        String zipType = this.getZipType(zipFile);
        if (zipType == null) {
            throw new IllegalStateException("databind.missingMetadata");
        }
        if (!objectType.equals(zipType)) {
            throw new IllegalStateException("databind.notMatchType");
        }
        CompletionStage<Object> databindReportCompletableFuture = CompletableFuture.completedFuture(Pair.of(null, (Object)zipFile));
        for (DatabindPlugin plugin : this.dataPreferencePlugins.values()) {
            if (!plugin.canHandleDatabind(objectType, null)) continue;
            databindReportCompletableFuture = databindReportCompletableFuture.thenCompose(previousResult -> {
                File updatedZip = (File)previousResult.getRight();
                return plugin.deserialize(updatedZip, params, username);
            });
        }
        return databindReportCompletableFuture.thenApply(Pair::getLeft);
    }

    private static void addMetadataFile(ZipOutputStream zipOut, String type) throws IOException {
        ZipEntry zipEntry = new ZipEntry("metadata.txt");
        zipOut.putNextEntry(zipEntry);
        zipOut.write(("type=" + type).getBytes());
        zipOut.closeEntry();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String getZipType(File zipFile) {
        try (ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(zipFile));){
            ZipEntry entry;
            while ((entry = zipInputStream.getNextEntry()) != null) {
                String line;
                if (!"metadata.txt".equals(entry.getName())) continue;
                BufferedReader reader = new BufferedReader(new InputStreamReader(zipInputStream));
                while ((line = reader.readLine()) != null) {
                    if (!line.startsWith("type=")) continue;
                    String string = line.split("=")[1].trim();
                    return string;
                }
            }
        }
        return null;
    }
}

