/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.jpa.search;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.search.domain.Document;
import org.exoplatform.commons.search.index.impl.ElasticIndexingServiceConnector;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.search.DocumentWithMetadata;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.metadata.MetadataService;
import org.exoplatform.social.metadata.model.MetadataObject;
import org.exoplatform.wiki.WikiException;
import org.exoplatform.wiki.model.Page;
import org.exoplatform.wiki.model.WikiType;
import org.exoplatform.wiki.service.NoteService;
import org.exoplatform.wiki.utils.Utils;

public class WikiPageIndexingServiceConnector
extends ElasticIndexingServiceConnector {
    public static final String TYPE = "wiki-page";
    private static final Log LOGGER = ExoLogger.getExoLogger(WikiPageIndexingServiceConnector.class);
    private final NoteService noteService;
    private final MetadataService metadataService;

    public WikiPageIndexingServiceConnector(InitParams initParams, NoteService noteService, MetadataService metadataService) {
        super(initParams);
        this.noteService = noteService;
        this.metadataService = metadataService;
    }

    public String getMapping() {
        StringBuilder mapping = new StringBuilder().append("{").append("  \"properties\" : {\n").append("    \"name\" : {").append("      \"type\" : \"text\",").append("      \"index_options\": \"offsets\",").append("      \"fields\": {").append("        \"raw\": {").append("          \"type\": \"keyword\"").append("        }").append("      }").append("    },\n").append("    \"title\" : {").append("      \"type\" : \"text\",").append("      \"index_options\": \"offsets\",").append("      \"fields\": {").append("        \"raw\": {").append("          \"type\": \"keyword\"").append("        }").append("      }").append("    },\n").append("    \"owner\" : {\"type\" : \"keyword\"},\n").append("    \"id\" : {\"type\" : \"long\"},\n").append("    \"wikiType\" : {\"type\" : \"keyword\"},\n").append("    \"wikiOwner\" : {\"type\" : \"keyword\"},\n").append("    \"permissions\" : {\"type\" : \"keyword\"},\n").append("    \"url\" : {\"type\" : \"text\", \"index\": false},\n").append("    \"sites\" : {\"type\" : \"keyword\"},\n").append("    \"comment\" : {\"type\" : \"text\", \"index_options\": \"offsets\"},\n").append("    \"content\" : {\"type\" : \"text\", \"store\": true, \"term_vector\": \"with_positions_offsets\"},\n").append("    \"createdDate\" : {\"type\" : \"date\", \"format\": \"epoch_millis\"},\n").append("    \"updatedDate\" : {\"type\" : \"date\", \"format\": \"epoch_millis\"},\n").append("    \"lastUpdatedDate\" : {\"type\" : \"date\", \"format\": \"epoch_millis\"}\n").append("  }\n").append("}");
        return mapping.toString();
    }

    public Document create(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new IllegalArgumentException("Id is null");
        }
        Page page = null;
        try {
            page = this.noteService.getNoteById(id);
        }
        catch (WikiException e) {
            LOGGER.error("Error while getting note with id {}", new Object[]{id, e});
        }
        if (page == null) {
            LOGGER.warn("The page with id {} wasn't found, thus it can't be indexed", new Object[]{id});
            return null;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)page.getOwner(), (CharSequence)IdentityConstants.SYSTEM)) {
            LOGGER.debug("The page with id {} is a system note pge, thus will not be searchable as a note", new Object[]{id});
            return null;
        }
        try {
            HashMap<String, String> fields = new HashMap<String, String>();
            fields.put("owner", page.getOwner());
            fields.put("name", page.getName());
            fields.put("id", String.valueOf(page.getId()));
            fields.put("content", Utils.html2text(page.getContent()));
            fields.put("title", page.getTitle());
            fields.put("createdDate", String.valueOf(page.getCreatedDate().getTime()));
            fields.put("updatedDate", String.valueOf(page.getUpdatedDate().getTime()));
            fields.put("comment", page.getComment());
            fields.put("wikiType", page.getWikiType());
            fields.put("wikiOwner", Utils.validateWikiOwner(page.getWikiType(), page.getWikiOwner()));
            DocumentWithMetadata document = new DocumentWithMetadata();
            document.setId(id);
            document.setUrl(Utils.getPageUrl(page));
            document.setLastUpdatedDate(page.getUpdatedDate());
            document.setPermissions(this.computePermissions(page));
            document.setFields(fields);
            this.addDocumentMetadata(document, page.getId());
            return document;
        }
        catch (Exception e) {
            LOGGER.info("Cannot index page with id {} ", new Object[]{id, e});
            return null;
        }
    }

    public Document update(String id) {
        return this.create(id);
    }

    public String getConnectorName() {
        return TYPE;
    }

    protected Set<String> computePermissions(Page page) {
        IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
        HashSet<String> permissions = new HashSet<String>();
        try {
            if (page.getWikiType().toUpperCase().equals(WikiType.GROUP.name())) {
                SpaceService spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
                Space space = spaceService.getSpaceByGroupId(page.getWikiOwner());
                if (space != null) {
                    permissions.add(identityManager.getOrCreateIdentity("space", space.getPrettyName()).getId());
                }
            } else if (page.getWikiType().toUpperCase().equals(WikiType.USER.name())) {
                permissions.add(identityManager.getOrCreateIdentity("organization", page.getWikiOwner()).getId());
            }
        }
        catch (Exception e) {
            LOGGER.warn("Cannot get Identity of the wiki Owner", new Object[]{e.getMessage()});
        }
        return permissions;
    }

    public List<String> getAllIds(int offset, int limit) {
        throw new UnsupportedOperationException();
    }

    protected void addDocumentMetadata(DocumentWithMetadata document, String documentId) {
        MetadataObject metadataObject = new MetadataObject("notes", documentId);
        List metadataItems = this.metadataService.getMetadataItemsByObject(metadataObject);
        document.setMetadataItems(metadataItems);
    }
}

