/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.oauth.utils;

import java.util.ArrayList;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.organization.UserProfile;

public class OAuthPersistenceUtils {
    public static final int DEFAULT_CHUNK_LENGTH = 250;

    private OAuthPersistenceUtils() {
    }

    public static void saveLongAttribute(String longAttribute, UserProfile userProfile, String attributePrefix, boolean useSuffixInFirstAttribute, int lengthOfOneChunk) {
        boolean chunkRemoved;
        ArrayList<String> chunks = new ArrayList<String>();
        while (longAttribute.length() > lengthOfOneChunk) {
            chunks.add(longAttribute.substring(0, lengthOfOneChunk));
            longAttribute = longAttribute.substring(lengthOfOneChunk);
        }
        chunks.add(longAttribute);
        int chunkCounter = 1;
        for (String chunk : chunks) {
            Object chunkAttrName = attributePrefix;
            if (useSuffixInFirstAttribute || chunkCounter > 1) {
                chunkAttrName = (String)chunkAttrName + "." + chunkCounter;
            }
            userProfile.setAttribute((String)chunkAttrName, chunk);
            ++chunkCounter;
        }
        do {
            chunkRemoved = false;
            Object chunkAttrName = attributePrefix;
            if (useSuffixInFirstAttribute || chunkCounter > 1) {
                chunkAttrName = (String)chunkAttrName + "." + chunkCounter;
            }
            if (userProfile.getAttribute((String)chunkAttrName) != null) {
                userProfile.setAttribute((String)chunkAttrName, null);
                chunkRemoved = true;
            }
            ++chunkCounter;
        } while (chunkRemoved);
    }

    public static void removeLongAttribute(UserProfile userProfile, String attributePrefix, boolean useSuffixInFirstAttribute) {
        boolean chunkRemoved;
        int chunkCounter = 1;
        do {
            chunkRemoved = false;
            Object chunkAttrName = attributePrefix;
            if (useSuffixInFirstAttribute || chunkCounter > 1) {
                chunkAttrName = (String)chunkAttrName + "." + chunkCounter;
            }
            if (userProfile.getAttribute((String)chunkAttrName) != null) {
                userProfile.setAttribute((String)chunkAttrName, null);
                chunkRemoved = true;
            }
            ++chunkCounter;
        } while (chunkRemoved);
    }

    public static String getLongAttribute(UserProfile userProfile, String attributePrefix, boolean useSuffixInFirstAttribute) {
        boolean chunkFound;
        int chunkCounter = 1;
        StringBuilder result = new StringBuilder();
        do {
            chunkFound = false;
            Object chunkAttrName = attributePrefix;
            if (useSuffixInFirstAttribute || chunkCounter > 1) {
                chunkAttrName = (String)chunkAttrName + "." + chunkCounter;
            }
            if (userProfile.getAttribute((String)chunkAttrName) != null) {
                result.append(userProfile.getAttribute((String)chunkAttrName));
                chunkFound = true;
            }
            ++chunkCounter;
        } while (chunkFound);
        String str = result.toString();
        return str.length() > 0 ? str : null;
    }

    public static int getChunkLength(InitParams params) {
        String chunkLengthParam = null;
        if (params.getValueParam("chunkLength") != null) {
            chunkLengthParam = params.getValueParam("chunkLength").getValue();
        }
        if (chunkLengthParam != null && !chunkLengthParam.isEmpty()) {
            return Integer.parseInt(chunkLengthParam);
        }
        return 250;
    }
}

