/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.service;

import io.meeds.gamification.dao.BadgeDAO;
import io.meeds.gamification.entity.BadgeEntity;
import io.meeds.gamification.model.BadgeDTO;
import io.meeds.gamification.storage.ProgramStorage;
import io.meeds.gamification.storage.mapper.BadgeMapper;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class BadgeService {
    private static final Log LOG = ExoLogger.getLogger(BadgeService.class);
    protected final ProgramStorage programStorage;
    protected final BadgeDAO badgeDAO;

    public BadgeService(ProgramStorage programStorage, BadgeDAO badgeDAO) {
        this.programStorage = programStorage;
        this.badgeDAO = badgeDAO;
    }

    public BadgeDTO findBadgeByTitle(String badgeTitle) {
        try {
            BadgeEntity entity = this.badgeDAO.findBadgeByTitle(badgeTitle);
            if (entity != null) {
                return BadgeMapper.fromEntity(this.programStorage, entity);
            }
        }
        catch (Exception e) {
            LOG.error("Error to find Badge entity with title : {}", new Object[]{badgeTitle, e.getMessage()});
        }
        return null;
    }

    public BadgeDTO findBadgeById(Long badgeId) {
        try {
            BadgeEntity entity = (BadgeEntity)this.badgeDAO.find(badgeId);
            if (entity != null) {
                return BadgeMapper.fromEntity(this.programStorage, entity);
            }
        }
        catch (Exception e) {
            LOG.error("Error to find Badge entity with id : {}", new Object[]{badgeId, e.getMessage()});
        }
        return null;
    }

    public BadgeDTO findBadgeByTitleAndProgramId(String badgeTitle, long programId) {
        try {
            BadgeEntity entity = this.badgeDAO.findBadgeByTitleAndProgramId(badgeTitle, programId);
            if (entity != null) {
                return BadgeMapper.fromEntity(this.programStorage, entity);
            }
        }
        catch (Exception e) {
            LOG.error("Error to find Badge entity with title : {}", new Object[]{badgeTitle, e.getMessage()});
        }
        return null;
    }

    public List<BadgeDTO> getAllBadges() {
        List<BadgeEntity> badges = this.badgeDAO.getAllBadges();
        if (CollectionUtils.isNotEmpty(badges)) {
            return BadgeMapper.fromEntities(this.programStorage, badges);
        }
        return Collections.emptyList();
    }

    public BadgeDTO addBadge(BadgeDTO badgeDTO) throws ObjectAlreadyExistsException {
        BadgeEntity badgeEntity = null;
        if (badgeDTO.getProgram() == null) {
            badgeDTO.setEnabled(false);
            badgeEntity = (BadgeEntity)this.badgeDAO.create(BadgeMapper.toEntity(badgeDTO));
        } else {
            badgeEntity = this.badgeDAO.findBadgeByTitleAndProgramId(badgeDTO.getTitle(), badgeDTO.getProgram().getId());
            if (badgeEntity == null) {
                if (!badgeDTO.getProgram().isEnabled()) {
                    badgeDTO.setEnabled(false);
                }
                badgeEntity = (BadgeEntity)this.badgeDAO.create(BadgeMapper.toEntity(badgeDTO));
            } else if (badgeEntity.isDeleted()) {
                Long id = badgeEntity.getId();
                badgeEntity = BadgeMapper.toEntity(badgeDTO);
                badgeEntity.setId(id);
                if (badgeDTO.getProgram() == null || !badgeDTO.getProgram().isEnabled()) {
                    badgeDTO.setEnabled(false);
                }
                badgeEntity = (BadgeEntity)this.badgeDAO.update(badgeEntity);
            } else {
                throw new ObjectAlreadyExistsException((Object)"Badge already exists");
            }
        }
        return BadgeMapper.fromEntity(this.programStorage, badgeEntity);
    }

    public BadgeDTO updateBadge(BadgeDTO badgeDTO) throws ObjectAlreadyExistsException {
        if (badgeDTO.getProgram() == null || !badgeDTO.getProgram().isEnabled() || badgeDTO.getProgram().isDeleted()) {
            badgeDTO.setEnabled(false);
        } else {
            BadgeEntity similarBadgeEntity = this.badgeDAO.findBadgeByTitleAndProgramId(badgeDTO.getTitle(), badgeDTO.getProgram().getId());
            if (similarBadgeEntity != null && badgeDTO.getId() != null && similarBadgeEntity.getId().longValue() != badgeDTO.getId().longValue()) {
                throw new ObjectAlreadyExistsException((Object)"Badge with same title and program already exist");
            }
        }
        BadgeEntity badgeEntity = (BadgeEntity)this.badgeDAO.update(BadgeMapper.toEntity(badgeDTO));
        return BadgeMapper.fromEntity(this.programStorage, badgeEntity);
    }

    public void deleteBadge(Long id) throws ObjectNotFoundException {
        BadgeEntity badgeEntity = (BadgeEntity)this.badgeDAO.find(id);
        if (badgeEntity == null) {
            throw new ObjectNotFoundException("Badge with id " + id + " not Found");
        }
        badgeEntity.setDeleted(true);
        this.badgeDAO.update(badgeEntity);
    }

    public List<BadgeDTO> findBadgesByProgramId(long programId) {
        try {
            List<BadgeEntity> badges = this.badgeDAO.findBadgesByProgramId(programId);
            if (badges != null) {
                return BadgeMapper.fromEntities(this.programStorage, badges);
            }
        }
        catch (Exception e) {
            LOG.error("Error to find badges within program id {}", new Object[]{programId, e});
        }
        return Collections.emptyList();
    }

    public List<BadgeDTO> findEnabledBadgesByProgramId(long programId) {
        try {
            List<BadgeEntity> badges = this.badgeDAO.findEnabledBadgesByProgramId(programId);
            if (badges != null) {
                return BadgeMapper.fromEntities(this.programStorage, badges);
            }
        }
        catch (Exception e) {
            LOG.error("Error to find badges within program id {}", new Object[]{programId, e});
        }
        return Collections.emptyList();
    }
}

