/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.storage.mapper;

import io.meeds.gamification.entity.BadgeEntity;
import io.meeds.gamification.model.BadgeDTO;
import io.meeds.gamification.storage.ProgramStorage;
import io.meeds.gamification.storage.mapper.ProgramMapper;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class BadgeMapper {
    public static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");

    private BadgeMapper() {
    }

    public static BadgeDTO fromEntity(ProgramStorage programStorage, BadgeEntity badgeEntity) {
        BadgeDTO badgeDTO = new BadgeDTO();
        badgeDTO.setId(badgeEntity.getId());
        badgeDTO.setTitle(badgeEntity.getTitle());
        badgeDTO.setDescription(badgeEntity.getDescription());
        badgeDTO.setNeededScore(badgeEntity.getNeededScore());
        badgeDTO.setStartValidityDate(BadgeMapper.formatDate(badgeEntity.getStartValidityDate()));
        badgeDTO.setEndValidityDate(BadgeMapper.formatDate(badgeEntity.getEndValidityDate()));
        badgeDTO.setEnabled(badgeEntity.isEnabled());
        badgeDTO.setDeleted(badgeEntity.isDeleted());
        badgeDTO.setCreatedBy(badgeEntity.getCreatedBy());
        badgeDTO.setCreatedDate(BadgeMapper.formatDate(badgeEntity.getCreatedDate()));
        badgeDTO.setLastModifiedBy(badgeEntity.getLastModifiedBy());
        badgeDTO.setLastModifiedDate(BadgeMapper.formatDate(badgeEntity.getLastModifiedDate()));
        badgeDTO.setProgram(badgeEntity.getDomainEntity() == null ? null : programStorage.getProgramById(badgeEntity.getDomainEntity().getId()));
        badgeDTO.setIconFileId(badgeEntity.getIconFileId());
        return badgeDTO;
    }

    public static List<BadgeDTO> fromEntities(ProgramStorage programStorage, List<BadgeEntity> badges) {
        return badges.stream().filter(Objects::nonNull).map(entity -> BadgeMapper.fromEntity(programStorage, entity)).toList();
    }

    public static BadgeEntity toEntity(BadgeDTO badgeDTO) {
        if (badgeDTO == null) {
            return null;
        }
        BadgeEntity badge = new BadgeEntity();
        badge.setId(badgeDTO.getId());
        badge.setTitle(badgeDTO.getTitle());
        badge.setDescription(badgeDTO.getDescription());
        badge.setNeededScore(badgeDTO.getNeededScore());
        badge.setIconFileId(badgeDTO.getIconFileId());
        if (badgeDTO.getStartValidityDate() != null) {
            badge.setStartValidityDate(BadgeMapper.parseDate(badgeDTO.getStartValidityDate()));
        }
        if (badgeDTO.getEndValidityDate() != null) {
            badge.setEndValidityDate(BadgeMapper.parseDate(badgeDTO.getEndValidityDate()));
        }
        badge.setEnabled(badgeDTO.isEnabled());
        badge.setDeleted(badgeDTO.isDeleted());
        badge.setCreatedBy(badgeDTO.getCreatedBy());
        if (badgeDTO.getCreatedDate() != null) {
            badge.setCreatedDate(BadgeMapper.parseDate(badgeDTO.getCreatedDate()));
        }
        badge.setLastModifiedBy(badgeDTO.getLastModifiedBy());
        if (badgeDTO.getLastModifiedDate() != null) {
            badge.setLastModifiedDate(BadgeMapper.parseDate(badgeDTO.getLastModifiedDate()));
        }
        badge.setDomainEntity(ProgramMapper.toEntity(badgeDTO.getProgram()));
        return badge;
    }

    private static Date parseDate(String dateString) {
        return dateString == null ? null : Date.from(LocalDate.parse(dateString, DATE_FORMATTER).atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
    }

    private static String formatDate(Date date) {
        return date == null ? null : LocalDate.ofInstant(date.toInstant(), ZoneId.systemDefault()).format(DATE_FORMATTER);
    }
}

