/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.kudos.listener;

import io.meeds.kudos.model.Kudos;
import io.meeds.kudos.service.KudosService;
import jakarta.annotation.PostConstruct;
import java.util.List;
import lombok.Generated;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.profile.ProfileLifeCycleEvent;
import org.exoplatform.social.core.profile.ProfileListenerPlugin;
import org.exoplatform.social.core.storage.api.ActivityStorage;
import org.exoplatform.social.core.storage.cache.CachedActivityStorage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProfileUpdateListener
extends ProfileListenerPlugin {
    @Autowired
    private ActivityStorage activityStorage;
    @Autowired
    private KudosService kudosService;
    @Autowired
    private IdentityManager identityManager;

    @PostConstruct
    public void init() {
        this.identityManager.registerProfileListener((ProfileListenerPlugin)this);
    }

    public void avatarUpdated(ProfileLifeCycleEvent event) {
        this.clearUserActivitiesCache(event);
    }

    public void contactSectionUpdated(ProfileLifeCycleEvent event) {
        this.clearUserActivitiesCache(event);
    }

    private void clearUserActivitiesCache(ProfileLifeCycleEvent event) {
        String userId = event.getProfile().getIdentity().getId();
        this.clearUserActivitiesCache(userId);
    }

    private void clearUserActivitiesCache(String userId) {
        long count = this.kudosService.countKudosByPeriodAndReceiver(Long.parseLong(userId), 0L, System.currentTimeMillis());
        if (count > 0L) {
            List<Kudos> kudosList = this.kudosService.getKudosByPeriodAndReceiver(Long.parseLong(userId), 0L, System.currentTimeMillis(), (int)count);
            if (kudosList == null || kudosList.isEmpty()) {
                return;
            }
            kudosList.stream().forEach(kudos -> ((CachedActivityStorage)this.activityStorage).clearActivityCached(String.valueOf(kudos.getActivityId())));
        }
    }

    @Generated
    public ProfileUpdateListener(ActivityStorage activityStorage, KudosService kudosService, IdentityManager identityManager) {
        this.activityStorage = activityStorage;
        this.kudosService = kudosService;
        this.identityManager = identityManager;
    }

    @Generated
    public ProfileUpdateListener() {
    }
}

