/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.task.listener;

import jakarta.annotation.PostConstruct;
import org.exoplatform.commons.search.index.IndexingService;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerBase;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.task.dto.TaskDto;
import org.exoplatform.task.service.TaskPayload;
import org.exoplatform.task.service.TaskService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Asynchronous
@Component
public class TaskIndexingListener
extends Listener<TaskService, TaskPayload> {
    private String[] LISTENERS = new String[]{"exo.task.taskCreation", "exo.task.taskUpdate", "exo.task.taskDeleted"};
    @Autowired
    private ListenerService listenerService;
    @Autowired
    private IndexingService indexingService;

    @PostConstruct
    public void init() {
        for (String listener : this.LISTENERS) {
            this.listenerService.addListener(listener, (ListenerBase)this);
        }
    }

    public void onEvent(Event<TaskService, TaskPayload> event) throws Exception {
        TaskPayload data = (TaskPayload)event.getData();
        TaskDto newTask = data.after();
        switch (event.getEventName()) {
            case "exo.task.taskCreation": {
                this.indexingService.index("task", String.valueOf(newTask.getId()));
                break;
            }
            case "exo.task.taskUpdate": {
                this.indexingService.reindex("task", String.valueOf(newTask.getId()));
                break;
            }
            case "exo.task.taskDeleted": {
                this.indexingService.unindex("task", String.valueOf(newTask.getId()));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected listener event name: " + event.getEventName());
            }
        }
    }
}

