/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.task.plugin;

import io.meeds.portal.plugin.AclPlugin;
import jakarta.annotation.PostConstruct;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.security.Identity;
import org.exoplatform.task.dto.ProjectDto;
import org.exoplatform.task.exception.EntityNotFoundException;
import org.exoplatform.task.service.ProjectService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProjectAclPlugin
implements AclPlugin {
    public static final String OBJECT_TYPE = "project";
    @Autowired
    private PortalContainer container;
    @Autowired
    private ProjectService projectService;

    @PostConstruct
    public void init() {
        ((UserACL)this.container.getComponentInstanceOfType(UserACL.class)).addAclPlugin((AclPlugin)this);
    }

    public String getObjectType() {
        return OBJECT_TYPE;
    }

    public boolean hasPermission(String objectId, String permissionType, Identity identity) {
        ProjectDto project;
        try {
            project = this.projectService.getProject(Long.parseLong(objectId));
        }
        catch (EntityNotFoundException e) {
            return false;
        }
        if (project == null) {
            return false;
        }
        return switch (permissionType) {
            case "VIEW" -> project.canView(identity);
            case "EDIT", "DELETE" -> project.canEdit(identity);
            default -> false;
        };
    }
}

