/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.task.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.search.es.ElasticSearchException;
import org.exoplatform.commons.search.es.client.ElasticSearchingClient;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.task.model.TaskSearchFilter;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class TaskSearchConnector {
    private static final Log LOG = ExoLogger.getLogger(TaskSearchConnector.class);
    @Autowired
    private ElasticSearchingClient client;
    @Value(value="${task.es.index:task_alias}")
    private String index;
    @Value(value="${task.search.type:task}")
    private String searchType;
    private static final String SEARCH_QUERY = "{\n  \"from\": @offset@,\n  \"size\": @limit@,\n  \"query\": {\n    \"bool\": {\n      \"must\": [\n        @term_query@\n        @permission_query@\n      ]\n    }\n  },\n  \"sort\": [\n    @sortQuery@\n  ]\n}\n";
    private static final String SEARCH_QUERY_TERM = "{\n  \"query_string\": {\n    \"fields\": [\"title\", \"description\"],\n    \"default_operator\": \"AND\",\n    \"query\": \"@term@\"\n  }\n},\n";
    private static final String PERMISSIONS_QUERY = "{\n  \"terms\": {\n    \"permissions\": [@permissions@]\n  }\n}\n";
    private static final String COUNT_QUERY = "{\n  \"query\": {\n    \"bool\": {\n      \"must\": [\n        @term_query@\n        @permission_query@\n      ]\n    }\n  }\n}\n";
    public static final String DEFAULT_SORTING_QUERY = "{\n  \"_score\": {\n    \"order\": \"desc\"\n  }\n}\n";
    public static final String SORTING_QUERY = "{\n  \"@sortField@\": {\n    \"order\": \"@sortOrder@\"\n  }\n},\n\"_score\"\n";
    private static final String OFFSET_REPLACEMENT = "@offset@";
    private static final String LIMIT_REPLACEMENT = "@limit@";
    private static final String TERM_REPLACEMENT = "@term@";
    private static final String TERM_QUERY_REPLACEMENT = "@term_query@";
    private static final String PERMISSIONS_QUERY_REPLACEMENT = "@permission_query@";
    private static final String PERMISSIONS_REPLACEMENT = "@permissions@";
    private static final String SORT_REPLACEMENT = "@sortQuery@";

    public List<Long> search(TaskSearchFilter filter) {
        String esQuery = this.buildSearchQuery(SEARCH_QUERY, filter);
        String jsonResponse = this.client.sendRequest(esQuery, this.index);
        return this.buildResult(jsonResponse);
    }

    public Long count(TaskSearchFilter filter) {
        filter.setLimit(0);
        filter.setOffset(0);
        String esQuery = this.buildSearchQuery(COUNT_QUERY, filter);
        String jsonResponse = this.client.countRequest(esQuery, this.index);
        return this.buildCount(jsonResponse);
    }

    private String buildSearchQuery(String queryBase, TaskSearchFilter filter) {
        String query = queryBase.replace(OFFSET_REPLACEMENT, String.valueOf(filter.getOffset())).replace(LIMIT_REPLACEMENT, String.valueOf(Math.max(filter.getLimit(), 10)));
        query = StringUtils.isNotBlank((CharSequence)filter.getTerm()) ? query.replace(TERM_QUERY_REPLACEMENT, SEARCH_QUERY_TERM.replace(TERM_REPLACEMENT, this.escapeJson(filter.getTerm()))) : query.replace(TERM_QUERY_REPLACEMENT, "");
        if (CollectionUtils.isNotEmpty(filter.getPermissions())) {
            String permissions = "\"" + String.join((CharSequence)"\",\"", filter.getPermissions()) + "\"";
            query = query.replace(PERMISSIONS_QUERY_REPLACEMENT, PERMISSIONS_QUERY.replace(PERMISSIONS_REPLACEMENT, permissions));
        } else {
            query = query.replace(PERMISSIONS_QUERY_REPLACEMENT, "");
        }
        query = StringUtils.isNotBlank((CharSequence)filter.getSortField()) ? query.replace(SORT_REPLACEMENT, this.buildSortQuery(filter)) : query.replace(SORT_REPLACEMENT, DEFAULT_SORTING_QUERY);
        return query;
    }

    private List<Long> buildResult(String jsonResponse) {
        Map json;
        JSONParser parser = new JSONParser();
        try {
            json = (Map)parser.parse(jsonResponse);
        }
        catch (ParseException e) {
            throw new ElasticSearchException("Unable to parse JSON response", (Throwable)e);
        }
        JSONObject hitsObj = (JSONObject)json.get("hits");
        if (hitsObj == null) {
            return Collections.emptyList();
        }
        JSONArray hits = (JSONArray)hitsObj.get((Object)"hits");
        ArrayList<Long> result = new ArrayList<Long>();
        for (Object hit : hits) {
            try {
                JSONObject hitObj = (JSONObject)hit;
                result.add(this.parseLong(hitObj, "_id"));
            }
            catch (Exception e) {
                LOG.warn("Error parsing hit item: {}", new Object[]{hit, e});
            }
        }
        return result;
    }

    private long buildCount(String jsonResponse) {
        JSONParser parser = new JSONParser();
        try {
            Map json = (Map)parser.parse(jsonResponse);
            String countString = json.getOrDefault("count", "0").toString();
            return Long.parseLong(countString);
        }
        catch (ParseException e) {
            throw new ElasticSearchException("Unable to parse JSON response", (Throwable)e);
        }
    }

    private Long parseLong(JSONObject hitSource, String key) {
        String value = (String)hitSource.get((Object)key);
        return StringUtils.isBlank((CharSequence)value) ? null : Long.valueOf(Long.parseLong(value));
    }

    private String escapeJson(String text) {
        return text.replaceAll("([\\Q+-!():^[]\"{}~*?|&/\\E])", " ").trim();
    }

    private String buildSortQuery(TaskSearchFilter filter) {
        String sortFiled = filter.getSortField();
        String sortDirection = filter.getSortDirection();
        return switch (sortFiled) {
            case "date" -> SORTING_QUERY.replace("@sortField@", "lastUpdatedDate").replace("@sortOrder@", sortDirection);
            default -> DEFAULT_SORTING_QUERY;
        };
    }
}

