/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.common.service.thread;

import java.util.concurrent.ThreadFactory;
import org.exoplatform.social.common.service.utils.ThreadHelper;

public final class SocialThreadFactory
implements ThreadFactory {
    private final String pattern;
    private final String name;
    private final boolean daemon;
    private final int priority;

    public SocialThreadFactory(String pattern, String name, boolean daemon, int priority) {
        this.pattern = pattern;
        this.name = name;
        this.daemon = daemon;
        this.priority = priority;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        String threadName = ThreadHelper.resolveThreadName(this.pattern, this.name);
        Thread answer = new Thread(runnable, threadName);
        answer.setDaemon(this.daemon);
        answer.setPriority(this.priority);
        return answer;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "SocialThreadFactory[" + this.name + "]";
    }
}

