/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.dao;

import jakarta.persistence.NoResultException;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.portal.jdbc.entity.SiteEntity;
import org.exoplatform.portal.mop.SiteFilter;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.dao.AbstractDAO;
import org.exoplatform.portal.mop.dao.NavigationDAO;
import org.exoplatform.portal.mop.dao.PageDAO;
import org.exoplatform.portal.mop.dao.SiteDAO;
import org.exoplatform.portal.mop.dao.SiteDAOImpl$AjcClosure1;
import org.exoplatform.portal.mop.dao.SiteDAOImpl$AjcClosure3;

public class SiteDAOImpl
extends AbstractDAO<SiteEntity>
implements SiteDAO {
    private static final String SITE_NAME = "name";
    private static final String SITE_TYPE = "siteType";
    private static final String DISPLAYED = "displayed";
    private static final String EXCLUDED_SITE_NAME = "excludedSiteName";
    private static final String EXCLUDED_SITE_TYPE = "excludedSiteType";
    private static final String SPACE_SITE_TYPE_PREFIX = "/spaces/";
    private static final String QUERY_FILTER_FIND_PREFIX = "SiteEntity.findSites";
    private final Map<String, Boolean> filterNamedQueries = new HashMap<String, Boolean>();
    private PageDAO pageDAO;
    private NavigationDAO navDAO;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    public SiteDAOImpl(PageDAO pageDAO, NavigationDAO navDAO) {
        this.pageDAO = pageDAO;
        this.navDAO = navDAO;
    }

    @ExoTransactional
    public void deleteAll(List<SiteEntity> entities) {
        List<SiteEntity> list = entities;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, list);
        Object[] objectArray = new Object[]{this, list, joinPoint};
        SiteDAOImpl$AjcClosure1 siteDAOImpl$AjcClosure1 = new SiteDAOImpl$AjcClosure1(objectArray);
        ExoTransactionalAspect.aspectOf().around(siteDAOImpl$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public void deleteAll() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        SiteDAOImpl$AjcClosure3 siteDAOImpl$AjcClosure3 = new SiteDAOImpl$AjcClosure3(objectArray);
        ExoTransactionalAspect.aspectOf().around(siteDAOImpl$AjcClosure3.linkClosureAndJoinPoint(69648));
    }

    @Override
    public SiteEntity findByKey(SiteKey siteKey) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SiteEntity.findByKey", SiteEntity.class);
        query.setParameter(SITE_TYPE, (Object)siteKey.getType());
        query.setParameter(SITE_NAME, (Object)siteKey.getName());
        try {
            return (SiteEntity)query.getSingleResult();
        }
        catch (NoResultException ex) {
            return null;
        }
    }

    @Override
    public List<SiteEntity> findByType(SiteType siteType) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SiteEntity.findByType", SiteEntity.class);
        query.setParameter(SITE_TYPE, (Object)siteType);
        return query.getResultList();
    }

    @Override
    public List<SiteKey> findSiteKey(SiteType siteType) {
        ArrayList<SiteKey> keys = new ArrayList<SiteKey>();
        TypedQuery query = this.getEntityManager().createNamedQuery("SiteEntity.findSiteKey", String.class);
        query.setParameter(SITE_TYPE, (Object)siteType);
        for (String name : query.getResultList()) {
            keys.add(new SiteKey(siteType, name));
        }
        return keys;
    }

    @Override
    public List<String> findGroupSites(int offset, int limit) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SiteEntity.findGroupSites", String.class);
        query.setParameter(SITE_TYPE, (Object)SiteType.GROUP);
        query.setParameter("excludeName", (Object)SPACE_SITE_TYPE_PREFIX);
        if (offset > 0) {
            query.setFirstResult(offset);
        }
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return query.getResultList();
    }

    @Override
    public List<String> findSpaceSites(int offset, int limit) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SiteEntity.findSpaceSites", String.class);
        query.setParameter(SITE_TYPE, (Object)SiteType.GROUP);
        query.setParameter("includeName", (Object)"/spaces/%");
        if (offset > 0) {
            query.setFirstResult(offset);
        }
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return query.getResultList();
    }

    @Override
    public List<String> findPortalSites(int offset, int limit) {
        return this.getSiteNames(SiteType.PORTAL, offset, limit);
    }

    @Override
    public List<String> findUserSites(int offset, int limit) {
        return this.getSiteNames(SiteType.USER, offset, limit);
    }

    @Override
    public List<SiteKey> findSitesKeys(SiteFilter siteFilter) {
        List resultList;
        TypedQuery query = this.buildQueryFromFilter(siteFilter);
        if (siteFilter.getOffset() > 0) {
            query.setFirstResult(siteFilter.getOffset());
        }
        if (siteFilter.getLimit() > 0) {
            query.setMaxResults(siteFilter.getLimit());
        }
        return (resultList = query.getResultList()) == null ? Collections.emptyList() : resultList;
    }

    private List<String> getSiteNames(SiteType siteType, int offset, int limit) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SiteEntity.findPortalSites", String.class);
        query.setParameter(SITE_TYPE, (Object)siteType);
        if (offset > 0) {
            query.setFirstResult(offset);
        }
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return query.getResultList();
    }

    private <T> TypedQuery<T> buildQueryFromFilter(SiteFilter filter) {
        TypedQuery query;
        ArrayList<String> suffixes = new ArrayList<String>();
        ArrayList<String> predicates = new ArrayList<String>();
        this.buildPredicates(filter, suffixes, predicates);
        String queryName = this.getQueryFilterName(suffixes);
        if (this.filterNamedQueries.containsKey(queryName)) {
            query = this.getEntityManager().createNamedQuery(queryName, SiteKey.class);
        } else {
            String queryContent = this.getQueryFilterContent(filter, predicates);
            query = this.getEntityManager().createQuery(queryContent, SiteKey.class);
            this.getEntityManager().getEntityManagerFactory().addNamedQuery(queryName, (Query)query);
            this.filterNamedQueries.put(queryName, true);
        }
        this.addQueryFilterParameters(filter, query);
        return query;
    }

    private void buildPredicates(SiteFilter filter, List<String> suffixes, List<String> predicates) {
        if (filter.getSiteType() != null) {
            suffixes.add("SiteType");
            predicates.add("s.siteType = :siteType");
        }
        if (filter.getExcludedSiteType() != null) {
            suffixes.add("ExcludedSiteType");
            predicates.add("s.siteType != :excludedSiteType");
        }
        if (filter.isFilterByDisplayed()) {
            suffixes.add("Displayed");
            predicates.add("s.displayed = :displayed");
        }
        if (StringUtils.isNotBlank((CharSequence)filter.getExcludedSiteName())) {
            suffixes.add("ExcludedSiteName");
            predicates.add("s.name != :excludedSiteName");
        }
        if (filter.isExcludeSpaceSites()) {
            suffixes.add("ExcludeSpaceSites");
            predicates.add("NOT(s.name LIKE '/spaces/%')");
        }
    }

    private String getQueryFilterName(List<String> suffixes) {
        return suffixes.isEmpty() ? QUERY_FILTER_FIND_PREFIX : "SiteEntity.findSitesBy" + StringUtils.join(suffixes, (String)"And");
    }

    private <T> void addQueryFilterParameters(SiteFilter filter, TypedQuery<T> query) {
        if (filter.getSiteType() != null) {
            query.setParameter(SITE_TYPE, (Object)filter.getSiteType());
        }
        if (filter.getExcludedSiteType() != null) {
            query.setParameter(EXCLUDED_SITE_TYPE, (Object)filter.getExcludedSiteType());
        }
        if (filter.isFilterByDisplayed()) {
            query.setParameter(DISPLAYED, (Object)filter.isDisplayed());
        }
        if (StringUtils.isNotBlank((CharSequence)filter.getExcludedSiteName())) {
            query.setParameter(EXCLUDED_SITE_NAME, (Object)filter.getExcludedSiteName());
        }
    }

    private String getQueryFilterContent(SiteFilter filter, List<String> predicates) {
        String querySelect = "SELECT new org.exoplatform.portal.mop.SiteKey(s.siteType, s.name) FROM GateInSite s ";
        Object queryContent = predicates.isEmpty() ? querySelect : querySelect + " WHERE " + StringUtils.join(predicates, (String)" AND ");
        String orderBy = filter.isSortByDisplayOrder() ? "s.displayOrder ASC, s.label ASC" : "s.label ASC";
        queryContent = (String)queryContent + " ORDER BY " + orderBy;
        return queryContent;
    }

    static {
        SiteDAOImpl.ajc$preClinit();
    }

    static final /* synthetic */ void deleteAll_aroundBody0(SiteDAOImpl ajc$this, List entities, JoinPoint joinPoint) {
        for (SiteEntity entity : entities) {
            ajc$this.navDAO.deleteByOwner(entity.getSiteType(), entity.getName());
            ajc$this.pageDAO.deleteByOwner(entity.getId());
            ajc$this.delete(entity);
        }
    }

    static final /* synthetic */ void deleteAll_aroundBody2(SiteDAOImpl ajc$this, JoinPoint joinPoint) {
        List entities = ajc$this.findAll();
        for (SiteEntity entity : entities) {
            ajc$this.navDAO.deleteByOwner(entity.getSiteType(), entity.getName());
            ajc$this.pageDAO.deleteByOwner(entity.getId());
            ajc$this.delete(entity);
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("SiteDAOImpl.java", SiteDAOImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteAll", "org.exoplatform.portal.mop.dao.SiteDAOImpl", "java.util.List", "entities", "", "void"), 69);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteAll", "org.exoplatform.portal.mop.dao.SiteDAOImpl", "", "", "", "void"), 79);
    }
}

