/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.analytics.listener.social;

import io.meeds.analytics.listener.social.AnalyticsActivityTagsListener$AjcClosure1;
import io.meeds.analytics.model.StatisticData;
import io.meeds.analytics.utils.AnalyticsUtils;
import jakarta.annotation.PostConstruct;
import java.util.Date;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerBase;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.metadata.tag.model.TagName;
import org.exoplatform.social.metadata.tag.model.TagObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Asynchronous
@Component
public class AnalyticsActivityTagsListener
extends Listener<TagObject, Set<TagName>> {
    private static final String EVENT_NAME = "metadata.tag.added";
    @Autowired
    private ActivityManager activityManager;
    @Autowired
    private ListenerService listenerService;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @PostConstruct
    public void init() {
        this.listenerService.addListener(EVENT_NAME, (ListenerBase)this);
    }

    @ExoTransactional
    public void onEvent(Event<TagObject, Set<TagName>> event) throws Exception {
        Event<TagObject, Set<TagName>> event2 = event;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), event2);
        Object[] objectArray = new Object[]{this, event2, joinPoint};
        AnalyticsActivityTagsListener$AjcClosure1 analyticsActivityTagsListener$AjcClosure1 = new AnalyticsActivityTagsListener$AjcClosure1(objectArray);
        ExoTransactionalAspect.aspectOf().around(analyticsActivityTagsListener$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    private void addEventStatistic(Set<TagName> tagNames, String activityId) {
        int numberOfTags = tagNames.size();
        ExoSocialActivity activity = this.activityManager.getActivity(activityId);
        String objectType = activity.getType() == null ? (activity.isComment() ? "COMMENT" : "ACTIVITY") : activity.getType();
        Identity audienceIdentity = this.activityManager.getActivityStreamOwnerIdentity(activity.getId());
        String username = this.getActivityPoster(activity);
        StatisticData statisticData = new StatisticData();
        statisticData.setModule("portal");
        statisticData.setSubModule("ui");
        statisticData.setOperation("Add tag");
        statisticData.setTimestamp(new Date().getTime());
        statisticData.setUserId(Long.parseLong(activity.getUserId()));
        statisticData.addParameter("username", (Object)username);
        statisticData.addParameter("type", (Object)objectType);
        statisticData.addParameter("dataType", (Object)StringUtils.lowerCase((String)objectType));
        statisticData.addParameter("spaceIdentityId", (Object)audienceIdentity.getIdentityId());
        for (int i = 0; i < numberOfTags; ++i) {
            AnalyticsUtils.addStatisticData((StatisticData)statisticData);
        }
    }

    private String getActivityPoster(ExoSocialActivity activity) {
        Validate.notNull((Object)activity.getUserId(), (String)"activity.getUserId() must not be null!", (Object[])new Object[0]);
        Identity identity = AnalyticsUtils.getIdentity((String)activity.getUserId());
        return identity == null ? null : identity.getRemoteId();
    }

    static {
        AnalyticsActivityTagsListener.ajc$preClinit();
    }

    static final /* synthetic */ void onEvent_aroundBody0(AnalyticsActivityTagsListener ajc$this, Event event, JoinPoint joinPoint) {
        TagObject tagObject = (TagObject)event.getSource();
        if (StringUtils.equals((CharSequence)tagObject.getType(), (CharSequence)"activity")) {
            ajc$this.addEventStatistic((Set)event.getData(), tagObject.getId());
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AnalyticsActivityTagsListener.java", AnalyticsActivityTagsListener.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "onEvent", "io.meeds.analytics.listener.social.AnalyticsActivityTagsListener", "org.exoplatform.services.listener.Event", "event", "java.lang.Exception", "void"), 67);
    }
}

