/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.core;

import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(template="system:/groovy/webui/core/UILazyTabPane.gtmpl", events={@EventConfig(listeners={SelectTabActionListener.class})})
public class UILazyTabPane
extends UIContainer {
    private static String selectedTabId = "";

    public String getSelectedTabId() {
        return selectedTabId;
    }

    public void setSelectedTab(String renderTabId) {
        selectedTabId = renderTabId;
    }

    public void setSelectedTab(int index) {
        selectedTabId = ((UIComponent)this.getChild(index - 1)).getId();
    }

    public static class SelectTabActionListener
    extends EventListener<UILazyTabPane> {
        @Override
        public void execute(Event<UILazyTabPane> event) throws Exception {
            WebuiRequestContext context = event.getRequestContext();
            String renderTab = context.getRequestParameter("objectId");
            UILazyTabPane uicomp = event.getSource();
            Object uiChild = uicomp.getChildById(renderTab);
            if (renderTab == null) {
                return;
            }
            selectedTabId = renderTab;
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiChild);
        }
    }
}

