/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.elasticsearch.inference.RateLimitSetting;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class HuggingFaceServiceSettings
implements JsonpSerializable {
    private final String apiKey;
    @Nullable
    private final RateLimitSetting rateLimit;
    private final String url;
    public static final JsonpDeserializer<HuggingFaceServiceSettings> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, HuggingFaceServiceSettings::setupHuggingFaceServiceSettingsDeserializer);

    private HuggingFaceServiceSettings(Builder builder) {
        this.apiKey = ApiTypeHelper.requireNonNull(builder.apiKey, this, "apiKey");
        this.rateLimit = builder.rateLimit;
        this.url = ApiTypeHelper.requireNonNull(builder.url, this, "url");
    }

    public static HuggingFaceServiceSettings of(Function<Builder, ObjectBuilder<HuggingFaceServiceSettings>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String apiKey() {
        return this.apiKey;
    }

    @Nullable
    public final RateLimitSetting rateLimit() {
        return this.rateLimit;
    }

    public final String url() {
        return this.url;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("api_key");
        generator.write(this.apiKey);
        if (this.rateLimit != null) {
            generator.writeKey("rate_limit");
            this.rateLimit.serialize(generator, mapper);
        }
        generator.writeKey("url");
        generator.write(this.url);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupHuggingFaceServiceSettingsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::apiKey, JsonpDeserializer.stringDeserializer(), "api_key");
        op.add(Builder::rateLimit, RateLimitSetting._DESERIALIZER, "rate_limit");
        op.add(Builder::url, JsonpDeserializer.stringDeserializer(), "url");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<HuggingFaceServiceSettings> {
        private String apiKey;
        @Nullable
        private RateLimitSetting rateLimit;
        private String url;

        public final Builder apiKey(String value) {
            this.apiKey = value;
            return this;
        }

        public final Builder rateLimit(@Nullable RateLimitSetting value) {
            this.rateLimit = value;
            return this;
        }

        public final Builder rateLimit(Function<RateLimitSetting.Builder, ObjectBuilder<RateLimitSetting>> fn) {
            return this.rateLimit(fn.apply(new RateLimitSetting.Builder()).build());
        }

        public final Builder url(String value) {
            this.url = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public HuggingFaceServiceSettings build() {
            this._checkSingleUse();
            return new HuggingFaceServiceSettings(this);
        }
    }
}

