/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.content.link.plugin;

import io.meeds.content.link.model.LinkData;
import io.meeds.content.link.service.LinkService;
import io.meeds.layout.model.PortletInstanceContext;
import io.meeds.layout.model.PortletInstancePreference;
import io.meeds.layout.plugin.PortletInstancePreferencePlugin;
import io.meeds.layout.service.PortletInstanceService;
import io.meeds.social.util.JsonUtils;
import jakarta.annotation.PostConstruct;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.pom.spi.portlet.Portlet;
import org.exoplatform.portal.pom.spi.portlet.Preference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Component
@Profile(value={"layout"})
public class LinkPortletInstancePreferencePlugin
implements PortletInstancePreferencePlugin {
    private static final String CMS_SETTING_PREFERENCE_NAME = "name";
    private static final String DATA_INIT_PREFERENCE_NAME = "data.init";
    @Autowired
    private LinkService linkService;
    @Autowired(required=false)
    private PortletInstanceService portletInstanceService;

    @PostConstruct
    public void init() {
        if (this.portletInstanceService == null) {
            this.portletInstanceService = (PortletInstanceService)ExoContainerContext.getService(PortletInstanceService.class);
        }
        this.portletInstanceService.addPortletInstancePreferencePlugin((PortletInstancePreferencePlugin)this);
    }

    public String getPortletName() {
        return "Links";
    }

    public List<PortletInstancePreference> generatePreferences(Application application, Portlet preferences, PortletInstanceContext portletInstanceContext) {
        String settingName = this.getCmsSettingName(preferences);
        if (StringUtils.isBlank((CharSequence)settingName)) {
            if (preferences != null && preferences.getPreference(DATA_INIT_PREFERENCE_NAME) != null) {
                return Collections.singletonList(new PortletInstancePreference(DATA_INIT_PREFERENCE_NAME, preferences.getPreference(DATA_INIT_PREFERENCE_NAME).getValue()));
            }
            return Collections.emptyList();
        }
        LinkData linkData = this.linkService.getLinkDataByName(settingName);
        return Collections.singletonList(new PortletInstancePreference(DATA_INIT_PREFERENCE_NAME, JsonUtils.toJsonString((Object)linkData)));
    }

    private String getCmsSettingName(Portlet preferences) {
        if (preferences == null) {
            return null;
        }
        Preference settingNamePreference = preferences.getPreference(CMS_SETTING_PREFERENCE_NAME);
        return settingNamePreference == null ? null : settingNamePreference.getValue();
    }
}

