/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jpa.persistenceunit;

import jakarta.persistence.Converter;
import jakarta.persistence.Embeddable;
import jakarta.persistence.Entity;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.PersistenceException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.context.index.CandidateComponentsIndex;
import org.springframework.context.index.CandidateComponentsIndexLoader;
import org.springframework.core.SpringProperties;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternUtils;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.ClassFormatException;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.lang.Nullable;
import org.springframework.orm.jpa.persistenceunit.ManagedClassNameFilter;
import org.springframework.orm.jpa.persistenceunit.PersistenceManagedTypes;
import org.springframework.orm.jpa.persistenceunit.SimplePersistenceManagedTypes;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ResourceUtils;

public final class PersistenceManagedTypesScanner {
    private static final String CLASS_RESOURCE_PATTERN = "/**/*.class";
    private static final String PACKAGE_INFO_SUFFIX = ".package-info";
    private static final String IGNORE_CLASSFORMAT_PROPERTY_NAME = "spring.classformat.ignore";
    private static final boolean shouldIgnoreClassFormatException = SpringProperties.getFlag((String)"spring.classformat.ignore");
    private static final Set<AnnotationTypeFilter> entityTypeFilters = CollectionUtils.newLinkedHashSet((int)4);
    private final ResourcePatternResolver resourcePatternResolver;
    @Nullable
    private final CandidateComponentsIndex componentsIndex;
    private final ManagedClassNameFilter managedClassNameFilter;

    public PersistenceManagedTypesScanner(ResourceLoader resourceLoader) {
        this(resourceLoader, null);
    }

    public PersistenceManagedTypesScanner(ResourceLoader resourceLoader, @Nullable ManagedClassNameFilter managedClassNameFilter) {
        this.resourcePatternResolver = ResourcePatternUtils.getResourcePatternResolver((ResourceLoader)resourceLoader);
        this.componentsIndex = CandidateComponentsIndexLoader.loadIndex((ClassLoader)resourceLoader.getClassLoader());
        this.managedClassNameFilter = managedClassNameFilter != null ? managedClassNameFilter : className -> true;
    }

    public PersistenceManagedTypes scan(String ... packagesToScan) {
        ScanResult scanResult = new ScanResult();
        for (String pkg : packagesToScan) {
            this.scanPackage(pkg, scanResult);
        }
        return scanResult.toJpaManagedTypes();
    }

    private void scanPackage(String pkg, ScanResult scanResult) {
        if (this.componentsIndex != null) {
            HashSet candidates = new HashSet();
            for (AnnotationTypeFilter filter : entityTypeFilters) {
                candidates.addAll(this.componentsIndex.getCandidateTypes(pkg, filter.getAnnotationType().getName()));
            }
            scanResult.managedClassNames.addAll(candidates.stream().filter(this.managedClassNameFilter::matches).toList());
            scanResult.managedPackages.addAll(this.componentsIndex.getCandidateTypes(pkg, "package-info"));
            return;
        }
        try {
            String pattern = "classpath*:" + ClassUtils.convertClassNameToResourcePath((String)pkg) + CLASS_RESOURCE_PATTERN;
            Resource[] resources = this.resourcePatternResolver.getResources(pattern);
            CachingMetadataReaderFactory factory = new CachingMetadataReaderFactory((ResourceLoader)this.resourcePatternResolver);
            for (Resource resource : resources) {
                try {
                    MetadataReader reader = factory.getMetadataReader(resource);
                    String className = reader.getClassMetadata().getClassName();
                    if (this.matchesEntityTypeFilter(reader, (MetadataReaderFactory)factory) && this.managedClassNameFilter.matches(className)) {
                        URL url;
                        scanResult.managedClassNames.add(className);
                        if (scanResult.persistenceUnitRootUrl != null || !ResourceUtils.isJarURL((URL)(url = resource.getURL()))) continue;
                        scanResult.persistenceUnitRootUrl = ResourceUtils.extractJarFileURL((URL)url);
                        continue;
                    }
                    if (!className.endsWith(PACKAGE_INFO_SUFFIX)) continue;
                    scanResult.managedPackages.add(className.substring(0, className.length() - PACKAGE_INFO_SUFFIX.length()));
                }
                catch (FileNotFoundException reader) {
                }
                catch (ClassFormatException ex) {
                    if (shouldIgnoreClassFormatException) continue;
                    throw new PersistenceException("Incompatible class format in " + String.valueOf(resource), (Throwable)ex);
                }
                catch (Throwable ex) {
                    throw new PersistenceException("Failed to read candidate component class: " + String.valueOf(resource), ex);
                }
            }
        }
        catch (IOException ex) {
            throw new PersistenceException("Failed to scan classpath for unlisted entity classes", (Throwable)ex);
        }
    }

    private boolean matchesEntityTypeFilter(MetadataReader reader, MetadataReaderFactory factory) throws IOException {
        for (TypeFilter typeFilter : entityTypeFilters) {
            if (!typeFilter.match(reader, factory)) continue;
            return true;
        }
        return false;
    }

    static {
        entityTypeFilters.add(new AnnotationTypeFilter(Entity.class, false));
        entityTypeFilters.add(new AnnotationTypeFilter(Embeddable.class, false));
        entityTypeFilters.add(new AnnotationTypeFilter(MappedSuperclass.class, false));
        entityTypeFilters.add(new AnnotationTypeFilter(Converter.class, false));
    }

    private static class ScanResult {
        private final List<String> managedClassNames = new ArrayList<String>();
        private final List<String> managedPackages = new ArrayList<String>();
        @Nullable
        private URL persistenceUnitRootUrl;

        private ScanResult() {
        }

        PersistenceManagedTypes toJpaManagedTypes() {
            return new SimplePersistenceManagedTypes(this.managedClassNames, this.managedPackages, this.persistenceUnitRootUrl);
        }
    }
}

