/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.security.SecuritySettings;
import co.elastic.clients.elasticsearch.security.UpdateSettingsResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class UpdateSettingsRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final Time masterTimeout;
    @Nullable
    private final SecuritySettings security;
    @Nullable
    private final SecuritySettings securityProfile;
    @Nullable
    private final SecuritySettings securityTokens;
    @Nullable
    private final Time timeout;
    public static final JsonpDeserializer<UpdateSettingsRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, UpdateSettingsRequest::setupUpdateSettingsRequestDeserializer);
    public static final Endpoint<UpdateSettingsRequest, UpdateSettingsResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<UpdateSettingsRequest, UpdateSettingsResponse>("es/security.update_settings", request -> "PUT", request -> "/_security/settings", request -> Collections.emptyMap(), request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout._toJsonString());
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout._toJsonString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, UpdateSettingsResponse._DESERIALIZER);

    private UpdateSettingsRequest(Builder builder) {
        this.masterTimeout = builder.masterTimeout;
        this.security = builder.security;
        this.securityProfile = builder.securityProfile;
        this.securityTokens = builder.securityTokens;
        this.timeout = builder.timeout;
    }

    public static UpdateSettingsRequest of(Function<Builder, ObjectBuilder<UpdateSettingsRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Time masterTimeout() {
        return this.masterTimeout;
    }

    @Nullable
    public final SecuritySettings security() {
        return this.security;
    }

    @Nullable
    public final SecuritySettings securityProfile() {
        return this.securityProfile;
    }

    @Nullable
    public final SecuritySettings securityTokens() {
        return this.securityTokens;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.security != null) {
            generator.writeKey("security");
            this.security.serialize(generator, mapper);
        }
        if (this.securityProfile != null) {
            generator.writeKey("security-profile");
            this.securityProfile.serialize(generator, mapper);
        }
        if (this.securityTokens != null) {
            generator.writeKey("security-tokens");
            this.securityTokens.serialize(generator, mapper);
        }
    }

    protected static void setupUpdateSettingsRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::security, SecuritySettings._DESERIALIZER, "security");
        op.add(Builder::securityProfile, SecuritySettings._DESERIALIZER, "security-profile");
        op.add(Builder::securityTokens, SecuritySettings._DESERIALIZER, "security-tokens");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<UpdateSettingsRequest> {
        @Nullable
        private Time masterTimeout;
        @Nullable
        private SecuritySettings security;
        @Nullable
        private SecuritySettings securityProfile;
        @Nullable
        private SecuritySettings securityTokens;
        @Nullable
        private Time timeout;

        public final Builder masterTimeout(@Nullable Time value) {
            this.masterTimeout = value;
            return this;
        }

        public final Builder masterTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.masterTimeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder security(@Nullable SecuritySettings value) {
            this.security = value;
            return this;
        }

        public final Builder security(Function<SecuritySettings.Builder, ObjectBuilder<SecuritySettings>> fn) {
            return this.security(fn.apply(new SecuritySettings.Builder()).build());
        }

        public final Builder securityProfile(@Nullable SecuritySettings value) {
            this.securityProfile = value;
            return this;
        }

        public final Builder securityProfile(Function<SecuritySettings.Builder, ObjectBuilder<SecuritySettings>> fn) {
            return this.securityProfile(fn.apply(new SecuritySettings.Builder()).build());
        }

        public final Builder securityTokens(@Nullable SecuritySettings value) {
            this.securityTokens = value;
            return this;
        }

        public final Builder securityTokens(Function<SecuritySettings.Builder, ObjectBuilder<SecuritySettings>> fn) {
            return this.securityTokens(fn.apply(new SecuritySettings.Builder()).build());
        }

        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public UpdateSettingsRequest build() {
            this._checkSingleUse();
            return new UpdateSettingsRequest(this);
        }
    }
}

