/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.util;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import com.fasterxml.jackson.databind.util.StdDateFormat;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.text.DateFormat;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;

public class JsonUtils {
    public static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    private JsonUtils() {
    }

    public static final <T> T fromJsonString(String value, Class<T> resultClass) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        return (T)OBJECT_MAPPER.readValue(value, resultClass);
    }

    public static final String toJsonString(Object object) {
        return OBJECT_MAPPER.writeValueAsString(object);
    }

    static {
        OBJECT_MAPPER.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        OBJECT_MAPPER.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        OBJECT_MAPPER.setVisibility((VisibilityChecker)VisibilityChecker.Std.defaultInstance().withFieldVisibility(JsonAutoDetect.Visibility.ANY));
        OBJECT_MAPPER.registerModule((Module)new JavaTimeModule());
        OBJECT_MAPPER.setDateFormat((DateFormat)new StdDateFormat().withTimeZone(TimeZone.getTimeZone("UTC")));
    }
}

