/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher.stats;

import co.elastic.clients.elasticsearch.watcher.ExecutionPhase;
import co.elastic.clients.elasticsearch.watcher.stats.WatchRecordQueuedStats;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.DateTime;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class WatchRecordStats
extends WatchRecordQueuedStats {
    private final ExecutionPhase executionPhase;
    private final DateTime triggeredTime;
    private final List<String> executedActions;
    private final String watchId;
    private final String watchRecordId;
    public static final JsonpDeserializer<WatchRecordStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, WatchRecordStats::setupWatchRecordStatsDeserializer);

    private WatchRecordStats(Builder builder) {
        super(builder);
        this.executionPhase = ApiTypeHelper.requireNonNull(builder.executionPhase, this, "executionPhase");
        this.triggeredTime = ApiTypeHelper.requireNonNull(builder.triggeredTime, this, "triggeredTime");
        this.executedActions = ApiTypeHelper.unmodifiable(builder.executedActions);
        this.watchId = ApiTypeHelper.requireNonNull(builder.watchId, this, "watchId");
        this.watchRecordId = ApiTypeHelper.requireNonNull(builder.watchRecordId, this, "watchRecordId");
    }

    public static WatchRecordStats of(Function<Builder, ObjectBuilder<WatchRecordStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final ExecutionPhase executionPhase() {
        return this.executionPhase;
    }

    public final DateTime triggeredTime() {
        return this.triggeredTime;
    }

    public final List<String> executedActions() {
        return this.executedActions;
    }

    public final String watchId() {
        return this.watchId;
    }

    public final String watchRecordId() {
        return this.watchRecordId;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("execution_phase");
        this.executionPhase.serialize(generator, mapper);
        generator.writeKey("triggered_time");
        this.triggeredTime.serialize(generator, mapper);
        if (ApiTypeHelper.isDefined(this.executedActions)) {
            generator.writeKey("executed_actions");
            generator.writeStartArray();
            for (String item0 : this.executedActions) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        generator.writeKey("watch_id");
        generator.write(this.watchId);
        generator.writeKey("watch_record_id");
        generator.write(this.watchRecordId);
    }

    protected static void setupWatchRecordStatsDeserializer(ObjectDeserializer<Builder> op) {
        WatchRecordQueuedStats.setupWatchRecordQueuedStatsDeserializer(op);
        op.add(Builder::executionPhase, ExecutionPhase._DESERIALIZER, "execution_phase");
        op.add(Builder::triggeredTime, DateTime._DESERIALIZER, "triggered_time");
        op.add(Builder::executedActions, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "executed_actions");
        op.add(Builder::watchId, JsonpDeserializer.stringDeserializer(), "watch_id");
        op.add(Builder::watchRecordId, JsonpDeserializer.stringDeserializer(), "watch_record_id");
    }

    public static class Builder
    extends WatchRecordQueuedStats.AbstractBuilder<Builder>
    implements ObjectBuilder<WatchRecordStats> {
        private ExecutionPhase executionPhase;
        private DateTime triggeredTime;
        @Nullable
        private List<String> executedActions;
        private String watchId;
        private String watchRecordId;

        public final Builder executionPhase(ExecutionPhase value) {
            this.executionPhase = value;
            return this;
        }

        public final Builder triggeredTime(DateTime value) {
            this.triggeredTime = value;
            return this;
        }

        public final Builder executedActions(List<String> list) {
            this.executedActions = Builder._listAddAll(this.executedActions, list);
            return this;
        }

        public final Builder executedActions(String value, String ... values) {
            this.executedActions = Builder._listAdd(this.executedActions, value, values);
            return this;
        }

        public final Builder watchId(String value) {
            this.watchId = value;
            return this;
        }

        public final Builder watchRecordId(String value) {
            this.watchRecordId = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public WatchRecordStats build() {
            this._checkSingleUse();
            return new WatchRecordStats(this);
        }
    }
}

