/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.management;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.management.ResourceKey;
import org.exoplatform.management.ValueWrapper;
import org.exoplatform.management.data.RestResource;
import org.exoplatform.management.rest.annotations.RESTEndpoint;
import org.exoplatform.management.spi.ManagedResource;
import org.exoplatform.management.spi.ManagementProvider;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;

@Path(value="management")
public class RestManagementProvider
implements ResourceContainer,
ManagementProvider {
    private final ExoContainerContext context;
    private final Map<ResourceKey, RestResource> resourceMap = new HashMap<ResourceKey, RestResource>();
    private final UserACL acl;

    public RestManagementProvider(ExoContainerContext context, UserACL acl) {
        this.context = context;
        this.acl = acl;
    }

    @GET
    @Produces(value={"application/json"})
    public Object list() {
        if (!this.acl.hasPermission(ConversationState.getCurrent().getIdentity(), "*:/platform/administrators")) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN);
        }
        ArrayList<String> list = new ArrayList<String>();
        for (RestResource mr : this.resourceMap.values()) {
            list.add(mr.getName());
        }
        return ValueWrapper.wrap(list);
    }

    @Path(value="{resource}")
    public Object dispatch(@PathParam(value="resource") String resourceName) {
        if (!this.acl.hasPermission(ConversationState.getCurrent().getIdentity(), "*:/platform/administrators")) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN);
        }
        return this.resourceMap.get(new ResourceKey(resourceName));
    }

    public Object manage(ManagedResource managedResource) {
        Object resource = managedResource.getResource();
        RESTEndpoint annotation = resource.getClass().getAnnotation(RESTEndpoint.class);
        if (annotation != null) {
            String name = annotation.path();
            ResourceKey key = new ResourceKey(name);
            this.resourceMap.put(key, new RestResource(name, managedResource));
            return key;
        }
        return null;
    }

    public void unmanage(Object key) {
        this.resourceMap.remove(key);
    }
}

