/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.search;

import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.search.es.ElasticSearchException;
import org.exoplatform.commons.search.es.client.ElasticSearchingClient;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.profileproperty.ProfilePropertyService;
import org.exoplatform.social.core.profileproperty.model.ProfilePropertySetting;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.search.Sorting;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class ProfileSearchConnector {
    private static final Log LOG = ExoLogger.getLogger(ProfileSearchConnector.class);
    private final ElasticSearchingClient client;
    private final ProfilePropertyService profilePropertyService;
    private String index;

    public ProfileSearchConnector(InitParams initParams, ElasticSearchingClient client, ProfilePropertyService profilePropertyService) {
        this.profilePropertyService = profilePropertyService;
        PropertiesParam param = initParams.getPropertiesParam("constructor.params");
        this.index = param.getProperty("index");
        this.client = client;
    }

    public List<String> search(Identity identity, ProfileFilter filter, Relationship.Type type, long offset, long limit) {
        if (identity == null && filter.getViewerIdentity() != null) {
            identity = filter.getViewerIdentity();
        }
        String esQuery = this.buildQueryStatement(identity, filter, type, offset, limit);
        String jsonResponse = this.client.sendRequest(esQuery, this.index);
        return this.buildResult(jsonResponse);
    }

    public int count(Identity identity, ProfileFilter filter, Relationship.Type type) {
        String esQuery = this.buildQueryStatement(identity, filter, type, 0L, 1L);
        String jsonResponse = this.client.sendRequest(esQuery, this.index);
        return this.getCount(jsonResponse);
    }

    private int getCount(String jsonResponse) {
        LOG.debug("Search Query response from ES : {} ", new Object[]{jsonResponse});
        JSONParser parser = new JSONParser();
        Map json = null;
        try {
            json = (Map)parser.parse(jsonResponse);
        }
        catch (ParseException e) {
            throw new ElasticSearchException("Unable to parse JSON response", (Throwable)e);
        }
        JSONObject jsonResult = (JSONObject)json.get("hits");
        if (jsonResult == null) {
            return 0;
        }
        Object totalSize = ((JSONObject)jsonResult.get((Object)"total")).get((Object)"value");
        return totalSize == null ? 0 : Integer.parseInt(totalSize.toString());
    }

    private List<String> buildResult(String jsonResponse) {
        LOG.debug("Search Query response from ES : {} ", new Object[]{jsonResponse});
        JSONParser parser = new JSONParser();
        Map json = null;
        try {
            json = (Map)parser.parse(jsonResponse);
        }
        catch (ParseException e) {
            throw new ElasticSearchException("Unable to parse JSON response", (Throwable)e);
        }
        JSONObject jsonResult = (JSONObject)json.get("hits");
        if (jsonResult == null) {
            return Collections.emptyList();
        }
        JSONArray jsonHits = (JSONArray)jsonResult.get((Object)"hits");
        ArrayList<String> results = new ArrayList<String>();
        for (Object jsonHit : jsonHits) {
            String identityId = (String)((JSONObject)jsonHit).get((Object)"_id");
            results.add(identityId);
        }
        return results;
    }

    private String buildQueryStatement(Identity identity, ProfileFilter filter, Relationship.Type type, long offset, long limit) {
        String sortField;
        String sortOrder;
        String expEs = this.buildExpression(filter);
        Map profileSettings = filter.getProfileSettings();
        String expEsForAdvancedFilter = MapUtils.isNotEmpty((Map)profileSettings) ? this.buildAdvancedFilterExpression(filter) : "";
        StringBuilder esQuery = new StringBuilder();
        esQuery.append("{\n");
        esQuery.append("   \"from\" : ").append(offset).append(", \"size\" : ").append(limit).append(",\n");
        Sorting sorting = filter.getSorting();
        esQuery.append("   \"sort\": {");
        String string = sortOrder = sorting != null && sorting.orderBy != null ? sorting.orderBy.name() : "asc";
        if (sorting != null && sorting.sortBy != null) {
            switch (sorting.sortBy) {
                case DATE: {
                    sortField = "\"lastUpdatedDate\"";
                    break;
                }
                case FIRSTNAME: {
                    sortField = "\"firstName.raw\"";
                    break;
                }
                case LASTNAME: {
                    sortField = "\"lastName.raw\"";
                    break;
                }
                default: {
                    sortField = "\"name.raw\"";
                    break;
                }
            }
        } else {
            sortField = "\"name.raw\"";
        }
        esQuery.append(sortField).append(": {\"order\": \"").append(sortOrder).append("\"}}\n");
        StringBuilder esSubQuery = new StringBuilder();
        esSubQuery.append("\"query\" : {\n");
        esSubQuery.append("      \"constant_score\" : {\n");
        esSubQuery.append("        \"filter\" : {\n");
        esSubQuery.append("          \"bool\" :{\n");
        boolean subQueryEmpty = true;
        boolean appendCommar = false;
        ArrayList<String> mustClauses = new ArrayList<String>();
        ArrayList<String> mustNotClauses = new ArrayList<String>();
        ArrayList<String> filterClauses = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty((Collection)filter.getSpaceIdentityIds())) {
            String permissionsQuery = this.buildSpacePermissionsExpression(filter);
            mustClauses.add(permissionsQuery);
            subQueryEmpty = false;
        }
        if (filter.getUserType() != null && !filter.getUserType().isEmpty()) {
            ArrayList<String> userTypeShoulds = new ArrayList<String>();
            if (filter.getUserType().equals("internal")) {
                userTypeShoulds.add("                  {\n                    \"term\": {\n                      \"external\": false\n                    }\n                  }");
                userTypeShoulds.add("                  {\n                    \"bool\": {\n                      \"must_not\": {\n                        \"exists\": {\n                          \"field\": \"external\"\n                        }\n                      }\n                    }\n                  }");
            } else if (filter.getUserType().equals("external")) {
                userTypeShoulds.add("                  {\n                    \"term\": {\n                      \"external\": true\n                    }\n                  }");
            }
            if (CollectionUtils.isNotEmpty(userTypeShoulds)) {
                StringBuilder userTypeBlockBuilder = new StringBuilder();
                userTypeBlockBuilder.append("      {\n").append("        \"bool\": {\n").append("          \"should\": [\n").append(String.join((CharSequence)",\n", userTypeShoulds)).append("          ],\n").append("          \"minimum_should_match\" : 1\n").append("        }\n").append("      }");
                mustClauses.add(userTypeBlockBuilder.toString());
                subQueryEmpty = false;
            }
        }
        if (filter.isConnected() != null) {
            StringBuilder existsClauseBuilder = new StringBuilder();
            existsClauseBuilder.append("                  {\n").append("                    \"bool\": {\n");
            if (filter.isConnected().booleanValue()) {
                existsClauseBuilder.append("                      \"must\": {\n");
            } else {
                existsClauseBuilder.append("                      \"must_not\": {\n");
            }
            existsClauseBuilder.append("                        \"exists\": {\n").append("                          \"field\": \"lastLoginTime\"\n").append("                        }\n").append("                      }\n").append("                    }\n").append("                  }");
            CharSequence connectedBlockBuilder = new StringBuilder();
            ((StringBuilder)connectedBlockBuilder).append("      {\n").append("        \"bool\": {\n").append("          \"should\": [\n").append(existsClauseBuilder.toString()).append("          ],\n").append("          \"minimum_should_match\" : 1\n").append("        }\n").append("      }");
            mustClauses.add(((StringBuilder)connectedBlockBuilder).toString());
            subQueryEmpty = false;
        }
        if (filter.getEnrollmentStatus() != null && !filter.getEnrollmentStatus().isEmpty()) {
            ArrayList<String> enrollmentShoulds = new ArrayList<String>();
            switch (filter.getEnrollmentStatus()) {
                case "enrolled": {
                    enrollmentShoulds.add("                  {\n                    \"bool\": {\n                      \"must\": {\n                        \"exists\": {\n                          \"field\": \"enrollmentDate\"\n                        }\n                      }\n                    }\n                  }");
                    break;
                }
                case "notEnrolled": {
                    enrollmentShoulds.add("                  {\n                    \"bool\": {\n                      \"must_not\": [{\n                        \"exists\": {\n                          \"field\": \"enrollmentDate\"\n                          }\n                        },\n                      {\n                        \"exists\": {\n                          \"field\": \"lastLoginTime\"\n                        }\n                      }],\n                      \"must\": {\n                       \"term\": {\n                         \"external\": false\n                         }\n                      }\n                    }\n                  }");
                    break;
                }
                case "noEnrollmentPossible": {
                    enrollmentShoulds.add("                  {\n                    \"bool\": {\n                      \"must_not\": {\n                        \"exists\": {\n                          \"field\": \"enrollmentDate\"\n                          }\n                        },\n                      \"must\": {\n                        \"exists\": {\n                          \"field\": \"lastLoginTime\"\n                        }\n                      }\n                    }\n                  }");
                    enrollmentShoulds.add("                  {\n                    \"term\": {\n                      \"external\": true\n                    }\n                  }");
                    break;
                }
            }
            if (CollectionUtils.isNotEmpty(enrollmentShoulds)) {
                StringBuilder enrollmentBlockBuilder = new StringBuilder();
                enrollmentBlockBuilder.append("      {\n").append("        \"bool\": {\n").append("          \"should\": [\n").append(String.join((CharSequence)",\n", enrollmentShoulds)).append("          ],\n").append("          \"minimum_should_match\" : 1\n").append("        }\n").append("      }");
                mustClauses.add(enrollmentBlockBuilder.toString());
                subQueryEmpty = false;
            }
        }
        if (filter.getRemoteIds() != null && !filter.getRemoteIds().isEmpty()) {
            StringBuilder remoteIds = new StringBuilder();
            for (String remoteId : filter.getRemoteIds()) {
                if (remoteIds.length() > 0) {
                    remoteIds.append(",");
                }
                remoteIds.append("\"").append(remoteId).append("\"");
            }
            StringBuilder remoteIdClauseBuilder = new StringBuilder();
            remoteIdClauseBuilder.append("      {\n").append("        \"terms\" :{\n").append("          \"userName\" : [").append(remoteIds.toString()).append("]\n").append("        } \n").append("      }\n");
            mustClauses.add(remoteIdClauseBuilder.toString());
            subQueryEmpty = false;
        }
        if (identity != null && type != null) {
            StringBuilder identityClauseBuilder = new StringBuilder();
            identityClauseBuilder.append("      {\n").append("        \"query_string\" : {\n").append("          \"query\" : \"").append(identity.getId()).append("\",\n").append("          \"fields\" : [\"").append(this.buildTypeEx(type)).append("\"]\n").append("        }\n").append("      }\n");
            mustClauses.add(identityClauseBuilder.toString());
            subQueryEmpty = false;
        } else if (filter.getExcludedIdentityList() != null && filter.getExcludedIdentityList().size() > 0) {
            StringBuilder excludedClauseBuilder = new StringBuilder();
            excludedClauseBuilder.append("      {\n").append("          \"ids\" : {\n").append("             \"values\" : [").append(this.buildExcludedIdentities(filter)).append("]\n").append("          }\n").append("        }\n");
            mustNotClauses.add(excludedClauseBuilder.toString());
            subQueryEmpty = false;
        }
        if (!expEs.isEmpty() || !expEsForAdvancedFilter.isEmpty()) {
            if (!expEs.isEmpty()) {
                StringBuilder qsClause = new StringBuilder();
                qsClause.append("      {");
                qsClause.append("          \"query_string\": {\n");
                if (filter.getName().startsWith("\"") && filter.getName().endsWith("\"")) {
                    qsClause.append("            \"query\": \"").append(expEs).append("\",\n").append("            \"default_operator\": \"").append("AND").append("\"\n");
                } else {
                    qsClause.append("            \"query\": \"").append(expEs).append("\"\n");
                }
                qsClause.append("          }\n");
                qsClause.append("      }\n");
                filterClauses.add(qsClause.toString());
            }
            if (!expEsForAdvancedFilter.isEmpty()) {
                filterClauses.add(expEsForAdvancedFilter);
            }
        }
        if (CollectionUtils.isNotEmpty(mustClauses)) {
            if (appendCommar) {
                esSubQuery.append("      ,\n");
            }
            esSubQuery.append("      \"must\": [\n");
            esSubQuery.append(String.join((CharSequence)",\n", mustClauses));
            esSubQuery.append("      ]\n");
            appendCommar = true;
        }
        if (CollectionUtils.isNotEmpty(mustNotClauses)) {
            if (appendCommar) {
                esSubQuery.append("      ,\n");
            }
            esSubQuery.append("      \"must_not\": [\n");
            esSubQuery.append(String.join((CharSequence)",\n", mustNotClauses));
            esSubQuery.append("      ]\n");
            appendCommar = true;
        }
        if (CollectionUtils.isNotEmpty(filterClauses)) {
            if (appendCommar) {
                esSubQuery.append("      ,\n");
            }
            esSubQuery.append("      \"filter\": [\n");
            esSubQuery.append(String.join((CharSequence)",\n", filterClauses));
            esSubQuery.append("      ]\n");
            appendCommar = true;
        }
        if (appendCommar) {
            subQueryEmpty = false;
        }
        esSubQuery.append("     } \n");
        esSubQuery.append("   } \n");
        esSubQuery.append("  }\n");
        esSubQuery.append(" }\n");
        if (!subQueryEmpty) {
            esQuery.append(",\n");
            esQuery.append((CharSequence)esSubQuery);
        }
        esQuery.append(",\"_source\": false\n");
        esQuery.append(",\"fields\": [\"_id\"]\n");
        esQuery.append("}\n");
        return esQuery.toString();
    }

    private String buildExcludedIdentities(ProfileFilter filter) {
        StringBuilder typeExp = new StringBuilder();
        if (filter.getExcludedIdentityList() != null && filter.getExcludedIdentityList().size() > 0) {
            Iterator iter = filter.getExcludedIdentityList().iterator();
            Identity first = (Identity)iter.next();
            typeExp.append("\"").append(first.getId()).append("\"");
            if (!iter.hasNext()) {
                return typeExp.toString();
            }
            while (iter.hasNext()) {
                Identity next = (Identity)iter.next();
                typeExp.append(",\"").append(next.getId()).append("\"");
            }
        }
        return typeExp.toString();
    }

    private String buildTypeEx(Relationship.Type type) {
        return switch (type) {
            case Relationship.Type.CONFIRMED -> "connections";
            case Relationship.Type.INCOMING -> "outgoings";
            case Relationship.Type.OUTGOING -> "incomings";
            default -> throw new IllegalArgumentException("Type [" + String.valueOf(type) + "] not supported");
        };
    }

    private String buildExpression(ProfileFilter filter) {
        String inputName;
        StringBuilder esExp = new StringBuilder();
        String string = inputName = StringUtils.isBlank((CharSequence)filter.getName()) ? null : filter.getName().replace("*", "");
        if (StringUtils.isNotBlank(inputName)) {
            String[] keys;
            String newInputName = inputName.trim();
            if (newInputName.startsWith("\"") && inputName.endsWith("\"")) {
                newInputName = inputName.replace("\"", "");
            }
            if ((keys = newInputName.split(" ")).length > 1) {
                StringBuilder nameEsExp = new StringBuilder();
                for (int i = 0; i < keys.length; ++i) {
                    if (!StringUtils.isNotBlank((CharSequence)keys[i])) continue;
                    if (i != 0) {
                        nameEsExp.append(") AND (");
                    }
                    String searchedWord = "*" + ProfileSearchConnector.removeAccents(keys[i]) + "*";
                    nameEsExp.append(" name.whitespace:").append(searchedWord);
                    if (filter.isSearchEmail()) {
                        nameEsExp.append(" OR email:").append(searchedWord);
                    }
                    if (!filter.isSearchUserName()) continue;
                    nameEsExp.append(" OR userName:").append(searchedWord);
                }
                if (StringUtils.isNotBlank((CharSequence)nameEsExp.toString())) {
                    esExp.append("(").append((CharSequence)nameEsExp).append(")");
                }
            } else if (StringUtils.isNotBlank((CharSequence)newInputName)) {
                String searchedText = "*" + ProfileSearchConnector.removeAccents(newInputName) + "*";
                esExp.append("name.whitespace:").append(searchedText);
                if (filter.isSearchEmail()) {
                    esExp.append(" OR email:").append(searchedText);
                }
                if (filter.isSearchUserName()) {
                    esExp.append(" OR userName:").append(searchedText);
                }
            } else {
                esExp.append("name.whitespace:").append("*").append(ProfileSearchConnector.removeAccents(newInputName)).append("*");
            }
        }
        return esExp.toString();
    }

    private String buildAdvancedFilterExpression(ProfileFilter filter) {
        Map settings = filter.getProfileSettings();
        if (MapUtils.isEmpty((Map)settings)) {
            return "";
        }
        StringBuilder query = new StringBuilder();
        int index = 0;
        for (String key : settings.keySet()) {
            ProfilePropertySetting property = this.profilePropertyService.getProfileSettingByName(key);
            if (property == null) continue;
            if (index > 0) {
                query.append(",");
            }
            String value = (String)settings.get(key);
            if (!StringUtils.isNotBlank((CharSequence)(value = ProfileSearchConnector.removeESReservedChars(value)))) continue;
            StringBuilder expression = new StringBuilder();
            String[] splittedValues = value.split(" ");
            if (splittedValues.length > 1) {
                for (int i = 0; i < splittedValues.length; ++i) {
                    if (!StringUtils.isNotBlank((CharSequence)splittedValues[i])) continue;
                    if (i != 0 && StringUtils.isNotBlank((CharSequence)expression)) {
                        expression.append(" AND ");
                    }
                    Object searchedText = filter.isWildcardSearch() ? "*" + ProfileSearchConnector.removeAccents(splittedValues[i]) + "*" : ProfileSearchConnector.removeAccents(splittedValues[i]);
                    expression.append(" ").append(key.replace(" ", "\\\\ ")).append(".whitespace").append(":").append((String)searchedText);
                }
                query.append("  {\n    \"query_string\": {\n      \"query\": \"%s\"\n    }\n }\n".formatted(expression.toString()));
            } else {
                String searchedText = ProfileSearchConnector.removeAccents(value);
                query.append("  {\n    \"match_phrase\": {\n      \"%s\": \"%s\"\n    }\n }\n".formatted(property.getPropertyName().replace(" ", "\\\\ "), searchedText));
            }
            ++index;
        }
        return query.toString();
    }

    private static String removeAccents(String string) {
        string = Normalizer.normalize(string, Normalizer.Form.NFD);
        string = string.replaceAll("[\\p{InCombiningDiacriticalMarks}]", "");
        return string;
    }

    public static String removeESReservedChars(String string) {
        String[] ES_RESERVED_CHARS;
        for (String c : ES_RESERVED_CHARS = new String[]{"+", "-", "=", "&&", "||", ">", "<", "!", "(", ")", "{", "}", "[", "]", "^", "\"", "~", "*", "?", ":", "\\", "/"}) {
            string = string.replace(c, " ");
        }
        return string;
    }

    private String buildSpacePermissionsExpression(ProfileFilter filter) {
        List permissions = filter.getSpaceIdentityIds();
        StringBuilder query = new StringBuilder();
        query.append("      {\n");
        query.append("        \"terms\": {\n");
        query.append("          \"permissions\": [\n");
        query.append(String.join((CharSequence)",\n", permissions));
        query.append("\n");
        query.append("          ]\n");
        query.append("        }\n");
        query.append("      }");
        return query.toString();
    }
}

