/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql;

import org.hibernate.Internal;
import org.hibernate.sql.Restriction;
import org.hibernate.sql.RestrictionRenderingContext;

@Internal
public class ComparisonRestriction
implements Restriction {
    private final String lhs;
    private final Operator operator;
    private final String rhs;

    public ComparisonRestriction(String lhs) {
        this(lhs, "?");
    }

    public ComparisonRestriction(String lhs, String rhs) {
        this(lhs, Operator.EQ, rhs);
    }

    public ComparisonRestriction(String lhs, Operator operator, String rhs) {
        this.lhs = lhs;
        this.operator = operator;
        this.rhs = rhs;
    }

    @Override
    public void render(StringBuilder sqlBuffer, RestrictionRenderingContext context) {
        sqlBuffer.append(this.lhs);
        sqlBuffer.append(this.operator.getSqlText());
        if ("?".equals(this.rhs)) {
            sqlBuffer.append(context.makeParameterMarker());
        } else {
            sqlBuffer.append(this.rhs);
        }
    }

    public static enum Operator {
        EQ("="),
        NE("<>");

        private final String sqlText;

        private Operator(String sqlText) {
            this.sqlText = sqlText;
        }

        public String getSqlText() {
            return this.sqlText;
        }
    }
}

