/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.perkstore.plugin;

import io.meeds.portal.permlink.model.PermanentLinkObject;
import io.meeds.portal.permlink.plugin.PermanentLinkPlugin;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.services.security.Identity;

public class PerkStorePermanentLinkPlugin
implements PermanentLinkPlugin {
    public static final String OBJECT_TYPE = "perkstore";
    public static final String PRODUCT_URL_FORMAT = "/portal/%s/perkstore?productId=%s";
    public static final String ORDER_URL_FORMAT = "/portal/%s/perkstore?productId=%s&orderId=%s";
    private UserPortalConfigService portalConfigService;

    public PerkStorePermanentLinkPlugin(UserPortalConfigService portalConfigService) {
        this.portalConfigService = portalConfigService;
    }

    public String getObjectType() {
        return OBJECT_TYPE;
    }

    public boolean canAccess(PermanentLinkObject object, Identity identity) throws ObjectNotFoundException {
        return true;
    }

    public String getDirectAccessUrl(PermanentLinkObject object) throws ObjectNotFoundException {
        String productId = object.getObjectId();
        if (object.getParameters() != null && object.getParameters().containsKey("orderId")) {
            return String.format(ORDER_URL_FORMAT, this.portalConfigService.getMetaPortal(), productId, object.getParameters().get("orderId"));
        }
        return String.format(PRODUCT_URL_FORMAT, this.portalConfigService.getMetaPortal(), productId);
    }
}

