/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.settings.jpa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.notification.channel.AbstractChannel;
import org.exoplatform.commons.api.notification.channel.ChannelManager;
import org.exoplatform.commons.api.notification.model.ChannelKey;
import org.exoplatform.commons.api.notification.model.GroupProvider;
import org.exoplatform.commons.api.notification.model.OrderComparatorASC;
import org.exoplatform.commons.api.notification.model.PluginInfo;
import org.exoplatform.commons.api.notification.plugin.GroupProviderPlugin;
import org.exoplatform.commons.api.notification.plugin.config.GroupConfig;
import org.exoplatform.commons.api.notification.plugin.config.PluginConfig;
import org.exoplatform.commons.api.notification.service.setting.PluginSettingService;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.notification.NotificationUtils;
import org.exoplatform.commons.notification.impl.AbstractService;
import org.exoplatform.commons.utils.MailUtils;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class JPAPluginSettingServiceImpl
extends AbstractService
implements PluginSettingService {
    public static final String NOTIFICATION_CHANNEL_STATUS_MODIFIED = "notification.channel.status.modified";
    public static final String NOTIFICATION_PLUGIN_STATUS_MODIFIED = "notification.plugin.status.modified";
    private static final Log LOG = ExoLogger.getLogger(JPAPluginSettingServiceImpl.class);
    private static final long SPECIFIC_CHANNEL_VERSION = 1L;
    private static final Scope NOTIFICATION_SCOPE = Scope.APPLICATION.id("NotificationSettings");
    private static final Context CHANNEL_CONTEXT = Context.GLOBAL.id("NotificationChannelSetting");
    private static final Scope CHANNEL_SCOPE = Scope.APPLICATION.id("NotificationChannelSetting");
    private static final Scope CHANNEL_DEFAULT_VALUE_SCOPE = Scope.APPLICATION.id("NotificationChannelSettingDefaultValue");
    private static final String NAME_SPACES = "exo:";
    private List<PluginConfig> pluginConfigs = new ArrayList<PluginConfig>();
    private Map<String, GroupProvider> groupPluginMap = new ConcurrentHashMap<String, GroupProvider>();
    private SettingService settingService;
    private ChannelManager channelManager;
    private ListenerService listenerService;

    public JPAPluginSettingServiceImpl(SettingService settingService, ChannelManager channelManager, ListenerService listenerService) {
        this.settingService = settingService;
        this.channelManager = channelManager;
        this.listenerService = listenerService;
    }

    public void registerPluginConfig(PluginConfig pluginConfig) {
        this.pluginConfigs.add(pluginConfig);
        Collections.sort(this.pluginConfigs, new OrderComparatorASC());
        if (!pluginConfig.isChildPlugin()) {
            PluginInfo pluginInfo = new PluginInfo();
            pluginInfo.setType(pluginConfig.getPluginId()).setOrder(Integer.valueOf(pluginConfig.getOrder()).intValue()).setResourceBundleKey(pluginConfig.getResourceBundleKey()).setBundlePath(pluginConfig.getBundlePath()).setMutable(pluginConfig.isMutable()).setDefaultConfig(pluginConfig.getDefaultConfig());
            String groupId = pluginConfig.getGroupId();
            GroupConfig gConfig = pluginConfig.getGroupConfig();
            if (gConfig != null) {
                groupId = gConfig.getId();
            }
            if (this.groupPluginMap.containsKey(groupId)) {
                this.groupPluginMap.get(groupId).addPluginInfo(pluginInfo);
            } else if (groupId != null && groupId.length() > 0) {
                GroupProvider groupProvider = new GroupProvider(groupId);
                groupProvider.addPluginInfo(pluginInfo);
                if (gConfig != null) {
                    groupProvider.setOrder(Integer.valueOf(gConfig.getOrder()).intValue());
                    groupProvider.setResourceBundleKey(gConfig.getResourceBundleKey());
                }
                this.groupPluginMap.put(groupId, groupProvider);
            }
        }
    }

    public void unregisterPluginConfig(PluginConfig pluginConfig) {
        this.pluginConfigs.remove(pluginConfig);
        List pluginInfos = this.groupPluginMap.get(pluginConfig.getGroupId()).getPluginInfos();
        PluginInfo pluginInfo = pluginInfos.stream().filter(info -> StringUtils.equals((CharSequence)info.getType(), (CharSequence)pluginConfig.getPluginId())).findFirst().orElse(null);
        if (pluginInfo != null) {
            pluginInfos.remove(pluginInfo);
        }
    }

    public void registerGroupConfig(GroupProviderPlugin groupConfigPlg) {
        for (GroupConfig gconfig : groupConfigPlg.getGroupProviders()) {
            GroupProvider groupProvider = new GroupProvider(gconfig.getId());
            groupProvider.setOrder(Integer.valueOf(gconfig.getOrder()).intValue());
            groupProvider.setResourceBundleKey(gconfig.getResourceBundleKey());
            if (this.groupPluginMap.containsKey(gconfig.getId())) {
                groupProvider.setPluginInfos(this.groupPluginMap.get(gconfig.getId()).getPluginInfos());
            }
            this.groupPluginMap.put(gconfig.getId(), groupProvider);
        }
    }

    public PluginConfig getPluginConfig(String pluginId) {
        for (PluginConfig pluginConfig : this.pluginConfigs) {
            if (!pluginConfig.getPluginId().equals(pluginId)) continue;
            return pluginConfig;
        }
        return null;
    }

    public List<GroupProvider> getGroupPlugins() {
        ArrayList<GroupProvider> groupProviders = new ArrayList<GroupProvider>();
        for (GroupProvider groupPlugin : this.groupPluginMap.values()) {
            groupProviders.add(groupPlugin);
        }
        Collections.sort(groupProviders, new OrderComparatorASC());
        return groupProviders;
    }

    public void saveActivePlugin(String channelId, String pluginId, boolean isActive) {
        List<String> current = this.getPluginChannels(pluginId);
        if (isActive) {
            if (!current.contains(channelId)) {
                current.add(channelId);
                this.saveActivePlugins(pluginId, current);
            }
        } else if (current.contains(channelId)) {
            current.remove(channelId);
            this.saveActivePlugins(pluginId, current);
        }
    }

    public void saveChannelStatus(String channelId, boolean enable) {
        this.settingService.set(CHANNEL_CONTEXT, CHANNEL_SCOPE, channelId, SettingValue.create((String)String.valueOf(enable)));
        try {
            this.listenerService.broadcast(NOTIFICATION_CHANNEL_STATUS_MODIFIED, (Object)channelId, null);
        }
        catch (Exception e) {
            LOG.warn((Object)"Error broadcasting channel status modification", (Throwable)e);
        }
    }

    public void saveChannelDefaultValue(String channelId, boolean enable) {
        this.settingService.set(CHANNEL_CONTEXT, CHANNEL_DEFAULT_VALUE_SCOPE, channelId, SettingValue.create((String)String.valueOf(enable)));
        try {
            this.listenerService.broadcast(NOTIFICATION_CHANNEL_STATUS_MODIFIED, (Object)channelId, null);
        }
        catch (Exception e) {
            LOG.warn((Object)"Error broadcasting channel status modification", (Throwable)e);
        }
    }

    public void saveEmailSender(String name, String email) {
        if (!NotificationUtils.isValidNotificationSenderName(name)) {
            throw new IllegalArgumentException("invalidSenderName");
        }
        if (!NotificationUtils.isValidEmailAddresses(email)) {
            throw new IllegalArgumentException("invalidSenderEmail");
        }
        this.settingService.set(Context.GLOBAL, Scope.GLOBAL, "exo:notificationSenderName", SettingValue.create((String)name));
        this.settingService.set(Context.GLOBAL, Scope.GLOBAL, "exo:notificationSenderEmail", SettingValue.create((String)email));
    }

    public String getEmailSenderName() {
        return MailUtils.getSenderName();
    }

    public String getEmailSenderEmail() {
        return MailUtils.getSenderEmail();
    }

    public boolean isChannelActive(String channelId) {
        SettingValue activeSettingValue = this.settingService.get(CHANNEL_CONTEXT, CHANNEL_SCOPE, channelId);
        return activeSettingValue == null || activeSettingValue.getValue() == null || StringUtils.equals((CharSequence)activeSettingValue.getValue().toString(), (CharSequence)"true");
    }

    public boolean getDefaultChannelValue(String channelId) {
        SettingValue channelDefaultValue = this.settingService.get(CHANNEL_CONTEXT, CHANNEL_DEFAULT_VALUE_SCOPE, channelId);
        return channelDefaultValue == null || channelDefaultValue.getValue() == null || StringUtils.equals((CharSequence)channelDefaultValue.getValue().toString(), (CharSequence)"true");
    }

    public boolean isActive(String channelId, String pluginId) {
        return this.isAllowed(channelId, pluginId) && this.getPluginChannels(pluginId).contains(channelId);
    }

    public boolean isAllowed(String channelId, String pluginId) {
        AbstractChannel channel = this.channelManager.getChannel(ChannelKey.key((String)channelId));
        PluginConfig pluginConfig = this.getPluginConfig(pluginId);
        return channel != null && channel.isEnabled() && pluginConfig != null && this.isChannelActive(channelId) && (channel.isDefaultChannel() || pluginConfig.getAdditionalChannels().contains(channelId));
    }

    public List<String> getPluginChannels(String pluginId) {
        List additionalChannels;
        List<Object> activeChannels;
        ArrayList<String> defaultChannels = new ArrayList<String>();
        for (Object channel : this.channelManager.getDefaultChannels()) {
            defaultChannels.add(channel.getId());
        }
        List specificChannels = this.channelManager.getSpecificChannels();
        for (AbstractChannel channel : specificChannels) {
            defaultChannels.remove(channel.getId());
        }
        SettingValue pluginActiveChannelsSetting = this.settingService.get(Context.GLOBAL, Scope.GLOBAL.id(null), NAME_SPACES + pluginId);
        if (pluginActiveChannelsSetting == null || pluginActiveChannelsSetting.getValue() == null) {
            activeChannels = defaultChannels;
        } else {
            String values = String.valueOf(pluginActiveChannelsSetting.getValue());
            activeChannels = NotificationUtils.stringToList(JPAPluginSettingServiceImpl.getValues(values));
        }
        PluginConfig pluginConfig = this.pluginConfigs.stream().filter(config -> StringUtils.equals((CharSequence)config.getPluginId(), (CharSequence)pluginId)).findFirst().orElse(null);
        if (pluginConfig != null && CollectionUtils.isNotEmpty((Collection)(additionalChannels = pluginConfig.getAdditionalChannels()))) {
            defaultChannels.addAll(additionalChannels);
            if (!this.isPluginSettingVersion(pluginId, 1L)) {
                activeChannels.addAll(additionalChannels);
            }
        }
        List allowedDefaultChannels = (List)CollectionUtils.intersection(defaultChannels, activeChannels);
        HashSet pluginChannels = new HashSet(allowedDefaultChannels);
        return new ArrayList<String>(pluginChannels);
    }

    public List<String> getActivePluginIds(String channelId) {
        HashSet<String> activePluginIds = new HashSet<String>();
        for (PluginConfig pluginConfig : this.pluginConfigs) {
            if (pluginConfig.isChildPlugin() || !this.isActive(channelId, pluginConfig.getPluginId())) continue;
            activePluginIds.add(pluginConfig.getPluginId());
        }
        return Collections.unmodifiableList(new ArrayList(activePluginIds));
    }

    public List<PluginInfo> getActivePlugins(String channelId) {
        HashSet<PluginInfo> activePlugins = new HashSet<PluginInfo>();
        for (GroupProvider groupPlugin : this.groupPluginMap.values()) {
            for (PluginInfo pluginInfo : groupPlugin.getPluginInfos()) {
                if (!this.isActive(channelId, pluginInfo.getType())) continue;
                activePlugins.add(pluginInfo);
            }
        }
        return Collections.unmodifiableList(new ArrayList(activePlugins));
    }

    public List<PluginInfo> getAllPlugins() {
        HashSet<PluginInfo> activePlugins = new HashSet<PluginInfo>();
        for (GroupProvider groupPlugin : this.groupPluginMap.values()) {
            for (PluginInfo pluginInfo : groupPlugin.getPluginInfos()) {
                activePlugins.add(pluginInfo);
            }
        }
        return Collections.unmodifiableList(new ArrayList(activePlugins));
    }

    private void saveActivePlugins(String pluginId, List<String> channels) {
        String activeChannelsString = NotificationUtils.listToString(channels, "{VALUE}");
        this.settingService.set(Context.GLOBAL, Scope.GLOBAL.id(null), NAME_SPACES + pluginId, SettingValue.create((String)activeChannelsString));
        this.savePluginSettingVersion(pluginId);
        try {
            this.listenerService.broadcast(NOTIFICATION_PLUGIN_STATUS_MODIFIED, (Object)pluginId, null);
        }
        catch (Exception e) {
            LOG.warn((Object)"Error broadcasting plugin status modification", (Throwable)e);
        }
    }

    private void savePluginSettingVersion(String pluginId) {
        this.settingService.set(Context.GLOBAL, NOTIFICATION_SCOPE, NAME_SPACES + pluginId, SettingValue.create((String)String.valueOf(1L)));
    }

    private boolean isPluginSettingVersion(String pluginId, long settingVersion) {
        SettingValue settingValue = this.settingService.get(Context.GLOBAL, NOTIFICATION_SCOPE, NAME_SPACES + pluginId);
        return settingValue != null && settingValue.getValue() != null && Long.parseLong(settingValue.getValue().toString()) >= settingVersion;
    }
}

