/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.jmx;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.NormalScope;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.PassivationCapable;
import javax.inject.Provider;
import javax.inject.Scope;
import javax.inject.Singleton;
import org.exoplatform.commons.utils.ClassLoading;
import org.exoplatform.container.AbstractComponentAdapter;
import org.exoplatform.container.ConcurrentContainer;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.component.ComponentLifecycle;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.context.AdvancedContext;
import org.exoplatform.container.context.ContextManager;
import org.exoplatform.container.context.DefinitionException;
import org.exoplatform.container.util.ContainerUtil;
import org.exoplatform.container.xml.Component;
import org.exoplatform.container.xml.ExternalComponentPlugins;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;

public class MX4JComponentAdapter<T>
extends AbstractComponentAdapter<T>
implements Contextual<T>,
PassivationCapable {
    private static final String PREFIX = MX4JComponentAdapter.class.getPackage().getName();
    private static final long serialVersionUID = -9001193588034229411L;
    protected volatile transient T instance_;
    private volatile transient T proxy;
    private volatile transient String id;
    protected final transient Lock lock;
    protected volatile boolean isSingleton = true;
    protected volatile transient boolean isInitialized;
    protected final transient AtomicReference<Class<? extends Annotation>> scope = new AtomicReference();
    private static final Log LOG = ExoLogger.getLogger((String)"exo.kernel.container.MX4JComponentAdapter");
    protected final transient ExoContainer exocontainer;
    private final transient ConcurrentContainer container;

    public MX4JComponentAdapter(ExoContainer holder, ConcurrentContainer container, Object key, Class<T> implementation) {
        this(holder, container, key, implementation, new ReentrantLock());
    }

    protected MX4JComponentAdapter(ExoContainer holder, ConcurrentContainer container, Object key, Class<T> implementation, Lock lock) {
        super(key, implementation);
        this.exocontainer = holder;
        this.container = container;
        this.lock = lock;
    }

    @Override
    public T getComponentInstance() {
        if (this.instance_ != null) {
            return this.instance_;
        }
        if (this.proxy != null) {
            return this.proxy;
        }
        if (!this.exocontainer.isContextManagerLoaded() && ContextManager.class.isAssignableFrom(this.getComponentImplementation())) {
            return this.create();
        }
        ContextManager manager = this.exocontainer.getContextManager();
        if (manager == null) {
            return this.create();
        }
        return this.create(manager, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T create(ContextManager manager, boolean retryAllowed) {
        Class<Annotation> scope = this.getScope(true, false);
        if (scope.equals(Unknown.class) || scope.equals(Singleton.class) || scope.equals(Dependent.class) || scope.equals(ApplicationScoped.class)) {
            return this.create();
        }
        final AdvancedContext ctx = manager.getContext(scope);
        if (ctx == null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("The scope {} is unknown, thus we will create the component {} out of a scope context.", new Object[]{scope.getName(), this.getComponentImplementation().getName()});
            }
            if (!retryAllowed) {
                throw new IllegalArgumentException("The scope and the default scope of the class " + this.getComponentImplementation().getName() + " are unknown");
            }
            try {
                Class<? extends Annotation> defaultScope = ContainerUtil.getScope(this.getComponentImplementation(), true);
                this.setScope(scope, defaultScope);
                return this.create(manager, false);
            }
            catch (DefinitionException e) {
                throw new IllegalArgumentException("The scope of the class " + this.getComponentImplementation().getName() + " is unknown and we cannot get a clear default scope: " + e.getMessage());
            }
        }
        NormalScope normalScope = scope.getAnnotation(NormalScope.class);
        if (normalScope != null) {
            if (normalScope.passivating() && !Serializable.class.isAssignableFrom(this.getComponentImplementation())) {
                throw new IllegalArgumentException("As the scope " + scope.getName() + " is a passivating scope, we expect only serializable objects and " + this.getComponentImplementation().getName() + " is not serializable.");
            }
            try {
                this.lock.lock();
                if (this.proxy != null) {
                    T t = this.proxy;
                    return t;
                }
                Object result = ContainerUtil.createProxy(this.getComponentImplementation(), new Provider<T>(){

                    public T get() {
                        return MX4JComponentAdapter.this.createInstance(ctx);
                    }
                });
                this.proxy = result;
                Object t = this.proxy;
                return t;
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.createInstance(ctx);
    }

    public Class<? extends Annotation> getScope() {
        return this.getScope(false, false);
    }

    private Class<? extends Annotation> getScope(boolean initializeIfNull, boolean ignoreExplicit) {
        Class<? extends Annotation> scope = this.scope.get();
        if (scope == null && initializeIfNull) {
            scope = ContainerUtil.getScope(this.getComponentImplementation(), ignoreExplicit);
            scope = this.setScope(null, scope);
        }
        return scope;
    }

    private Class<? extends Annotation> setScope(Class<? extends Annotation> expect, Class<? extends Annotation> scope) {
        if (scope == null) {
            scope = Unknown.class;
            this.isSingleton = true;
        } else {
            boolean bl = this.isSingleton = scope.equals(Singleton.class) || scope.equals(ApplicationScoped.class);
        }
        if (this.scope.compareAndSet(expect, scope)) {
            return scope;
        }
        return this.scope.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T createInstance(Context ctx) {
        Object result = ctx.get((Contextual)this);
        if (result != null) {
            return (T)result;
        }
        try {
            Object object = ctx.get((Contextual)this, this.container.addComponentToCtx(this.getComponentKey()));
            return (T)object;
        }
        finally {
            this.container.removeComponentFromCtx(this.getComponentKey());
        }
    }

    private T createInstance(ConcurrentContainer.CreationalContextComponentAdapter<T> ctx, Component component, ConfigurationManager manager, String componentKey, InitParams params, boolean debug) throws Exception {
        ExternalComponentPlugins ecplugins;
        boolean hasOnlyEmptyPublicConstructor;
        Class implementationClass = this.getComponentImplementation();
        Object instance = this.exocontainer.createComponent(implementationClass, params);
        if (this.instance_ != null) {
            return this.instance_;
        }
        if (ctx.get() != null) {
            return ctx.get();
        }
        ctx.push(instance);
        boolean isSingleton = this.isSingleton;
        boolean isInitialized = this.isInitialized;
        if (debug) {
            LOG.debug((Object)("==> create  component : " + String.valueOf(instance)));
        }
        boolean hasInjectableConstructor = !isSingleton || ContainerUtil.hasInjectableConstructor(implementationClass);
        boolean bl = hasOnlyEmptyPublicConstructor = !isSingleton || ContainerUtil.hasOnlyEmptyPublicConstructor(implementationClass);
        if (hasInjectableConstructor || hasOnlyEmptyPublicConstructor) {
            boolean isInjectPresent = this.container.initializeComponent(instance);
            isSingleton = this.manageScope(isSingleton, isInitialized, hasInjectableConstructor, isInjectPresent);
        } else if (!isInitialized) {
            this.isSingleton = true;
            isSingleton = true;
            this.scope.set(Singleton.class);
        }
        if (component != null && component.getComponentPlugins() != null) {
            this.addComponentPlugin(debug, instance, component.getComponentPlugins(), this.exocontainer);
        }
        ExternalComponentPlugins externalComponentPlugins = ecplugins = manager == null ? null : manager.getConfiguration().getExternalComponentPlugins(componentKey);
        if (ecplugins != null) {
            this.addComponentPlugin(debug, instance, ecplugins.getComponentPlugins(), this.exocontainer);
        }
        if (instance instanceof ComponentLifecycle) {
            ComponentLifecycle lc = (ComponentLifecycle)instance;
            lc.initComponent(this.exocontainer);
        }
        if (!isInitialized) {
            if (isSingleton) {
                this.instance_ = instance;
            }
            this.isInitialized = true;
        }
        return instance;
    }

    @Override
    public boolean isSingleton() {
        return this.isInitialized ? this.isSingleton : (this.isSingleton = ContainerUtil.isSingleton(this.getComponentImplementation()));
    }

    private void addComponentPlugin(boolean debug, Object component, List<org.exoplatform.container.xml.ComponentPlugin> plugins, ExoContainer container) throws Exception {
        if (plugins == null) {
            return;
        }
        for (org.exoplatform.container.xml.ComponentPlugin plugin : plugins) {
            try {
                Class pluginClass = ClassLoading.forName((String)plugin.getType(), (Object)this);
                ComponentPlugin cplugin = (ComponentPlugin)container.createComponent(pluginClass, plugin.getInitParams());
                cplugin.setName(plugin.getName());
                cplugin.setDescription(plugin.getDescription());
                Class<?> clazz = component.getClass();
                Method m = MX4JComponentAdapter.getSetMethod(clazz, plugin.getSetMethod(), pluginClass);
                if (m == null) {
                    LOG.error((Object)("Cannot find the method '" + plugin.getSetMethod() + "' that has only one parameter of type '" + pluginClass.getName() + "' in the class '" + clazz.getName() + "'."));
                    continue;
                }
                Object[] params = new Object[]{cplugin};
                m.invoke(component, params);
                if (debug) {
                    LOG.debug((Object)("==> add component plugin: " + String.valueOf(cplugin)));
                }
                cplugin.setName(plugin.getName());
                cplugin.setDescription(plugin.getDescription());
            }
            catch (Exception ex) {
                LOG.error((Object)("Failed to instanciate plugin " + plugin.getName() + " for component " + String.valueOf(component) + ": " + ex.getMessage()), (Throwable)ex);
            }
        }
    }

    protected static Method getSetMethod(Class<?> clazz, String name, Class<?> pluginClass) {
        Method[] methods = clazz.getMethods();
        Method bestCandidate = null;
        int depth = -1;
        for (Method m : methods) {
            Class<?>[] types;
            if (!name.equals(m.getName()) || (types = m.getParameterTypes()) == null || types.length != 1 || !ComponentPlugin.class.isAssignableFrom(types[0]) || !types[0].isAssignableFrom(pluginClass)) continue;
            int currentDepth = MX4JComponentAdapter.getClosestMatchDepth(pluginClass, types[0]);
            if (currentDepth == 0) {
                return m;
            }
            if (depth != -1 && depth <= currentDepth) continue;
            bestCandidate = m;
            depth = currentDepth;
        }
        return bestCandidate;
    }

    private static int getClosestMatchDepth(Class<?> pluginClass, Class<?> type) {
        return MX4JComponentAdapter.getClosestMatchDepth(pluginClass, type, 0);
    }

    private static int getClosestMatchDepth(Class<?> pluginClass, Class<?> type, int depth) {
        if (pluginClass == null || pluginClass.isAssignableFrom(type)) {
            return depth;
        }
        return MX4JComponentAdapter.getClosestMatchDepth(pluginClass.getSuperclass(), type, depth + 1);
    }

    protected T create() {
        boolean toBeLocked = !this.isInitialized;
        try {
            if (toBeLocked) {
                this.lock.lock();
            }
            Object t = this.create(this.container.addComponentToCtx(this.getComponentKey()));
            return t;
        }
        finally {
            if (toBeLocked) {
                this.lock.unlock();
            }
            this.container.removeComponentFromCtx(this.getComponentKey());
        }
    }

    public T create(CreationalContext<T> creationalContext) {
        T instance;
        Component component = null;
        InitParams params = null;
        boolean debug = false;
        ConcurrentContainer.CreationalContextComponentAdapter ctx = (ConcurrentContainer.CreationalContextComponentAdapter)creationalContext;
        try {
            if (this.instance_ != null) {
                return this.instance_;
            }
            if (ctx.get() != null) {
                return ctx.get();
            }
            Object key = this.getComponentKey();
            String componentKey = key instanceof String ? (String)key : ((Class)key).getName();
            ConfigurationManager manager = this.exocontainer.getComponentInstanceOfType(ConfigurationManager.class);
            Component component2 = component = manager == null ? null : manager.getComponent(componentKey);
            if (component != null) {
                params = component.getInitParams();
                debug = component.getShowDeployInfo();
            }
            if ((instance = this.createInstance(ctx, component, manager, componentKey, params, debug)) instanceof Startable && this.exocontainer.canBeStopped()) {
                ((Startable)instance).start();
            }
        }
        catch (Exception ex) {
            String msg = "Cannot instantiate component " + String.valueOf(this.getComponentImplementation());
            if (component != null) {
                msg = "Cannot instantiate component key=" + component.getKey() + " type=" + component.getType() + " found at " + String.valueOf(component.getDocumentURL());
            }
            throw new RuntimeException(msg, ex);
        }
        return instance;
    }

    public void destroy(T instance, CreationalContext<T> creationalContext) {
        try {
            creationalContext.release();
        }
        catch (Exception e) {
            LOG.error((Object)("Could not destroy the instance " + String.valueOf(instance) + ": " + e.getMessage()));
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getComponentKey() == null ? 0 : this.getComponentKey().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MX4JComponentAdapter other = (MX4JComponentAdapter)obj;
        return !(this.getComponentKey() == null ? other.getComponentKey() != null : !this.getComponentKey().equals(other.getComponentKey()));
    }

    public String getId() {
        if (this.id != null) {
            return this.id;
        }
        StringBuilder sb = new StringBuilder(PREFIX);
        Object key = this.getComponentKey();
        String componentKey = key instanceof String ? (String)key : ((Class)key).getName();
        this.id = sb.append(componentKey).toString();
        return this.id;
    }

    protected boolean manageScope(boolean isSingleton, boolean isInitialized, boolean hasInjectableConstructor, boolean isInjectPresent) {
        if (!isInitialized) {
            if (isInjectPresent || hasInjectableConstructor) {
                Class<? extends Annotation> currentScope = this.scope.get();
                if (!(currentScope != null || (currentScope = this.getScope(true, false)).equals(Unknown.class) || currentScope.equals(Singleton.class) || currentScope.equals(Dependent.class) || currentScope.equals(ApplicationScoped.class))) {
                    this.scope.compareAndSet(currentScope, null);
                    currentScope = this.getScope(true, true);
                    if (!(currentScope.equals(Unknown.class) || currentScope.equals(Singleton.class) || currentScope.equals(Dependent.class) || currentScope.equals(ApplicationScoped.class))) {
                        this.scope.compareAndSet(currentScope, Unknown.class);
                        currentScope = Unknown.class;
                    }
                }
                if (currentScope.equals(Unknown.class)) {
                    this.isSingleton = false;
                    isSingleton = false;
                    this.scope.set(Dependent.class);
                } else {
                    isSingleton = this.isSingleton;
                }
            } else {
                this.isSingleton = true;
                isSingleton = true;
                this.scope.set(Singleton.class);
            }
        }
        return isSingleton;
    }

    @Scope
    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    private static @interface Unknown {
    }
}

