/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.user;

import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.ResourceBundle;
import org.exoplatform.commons.utils.ExpressionUtil;
import org.exoplatform.commons.utils.HTMLEntityEncoder;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.mop.State;
import org.exoplatform.portal.mop.Visibility;
import org.exoplatform.portal.mop.navigation.NodeContext;
import org.exoplatform.portal.mop.navigation.NodeState;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.storage.DescriptionStorage;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserNodeContext;
import org.exoplatform.services.resources.ResourceBundleService;
import org.gatein.common.util.EmptyResourceBundle;

public class UserNode {
    final UserNodeContext owner;
    final NodeContext<UserNode> context;
    String uri;
    String cachedResolvedLabel;

    UserNode(UserNodeContext owner, NodeContext<UserNode> context) {
        this.owner = owner;
        this.context = context;
        this.uri = null;
    }

    public UserNavigation getNavigation() {
        return this.owner.navigation;
    }

    public String getId() {
        return this.context.getId();
    }

    public UserNode filter() {
        this.owner.filter(this);
        return this;
    }

    public String getName() {
        return this.context.getName();
    }

    public void setName(String name) {
        this.context.setName(name);
        this.uri = null;
    }

    public String getURI() {
        if (this.uri == null) {
            this.uri = this.buildURI().toString();
        }
        return this.uri;
    }

    private StringBuilder buildURI() {
        UserNode parent = (UserNode)this.context.getParentNode();
        if (parent != null) {
            StringBuilder builder = parent.buildURI();
            if (builder.length() > 0) {
                builder.append('/');
            }
            return builder.append(this.context.getName());
        }
        return new StringBuilder();
    }

    public String getLabel() {
        return this.context.getState().getLabel();
    }

    public void setLabel(String label) {
        this.context.setState(new NodeState.Builder(this.context.getState()).label(label).build());
    }

    public String getIcon() {
        return this.context.getState().getIcon();
    }

    public void setIcon(String icon) {
        this.context.setState(new NodeState.Builder(this.context.getState()).icon(icon).build());
    }

    public long getStartPublicationTime() {
        return this.context.getState().getStartPublicationTime();
    }

    public void setStartPublicationTime(long startPublicationTime) {
        this.context.setState(new NodeState.Builder(this.context.getState()).startPublicationTime(startPublicationTime).build());
    }

    public long getEndPublicationTime() {
        return this.context.getState().getEndPublicationTime();
    }

    public void setEndPublicationTime(long endPublicationTime) {
        this.context.setState(new NodeState.Builder(this.context.getState()).endPublicationTime(endPublicationTime).build());
    }

    public Visibility getVisibility() {
        return this.context.getState().getVisibility();
    }

    public void setVisibility(Visibility visibility) {
        this.context.setState(new NodeState.Builder(this.context.getState()).visibility(visibility).build());
    }

    public PageKey getPageRef() {
        return this.context.getState().getPageRef();
    }

    public void setPageRef(PageKey pageRef) {
        this.context.setState(new NodeState.Builder(this.context.getState()).pageRef(pageRef).build());
    }

    public String getTarget() {
        return this.context.getState().getTarget();
    }

    public void setTarget(String target) {
        this.context.setState(new NodeState.Builder(this.context.getState()).target(target).build());
    }

    public long getUpdatedDate() {
        return this.context.getState().getUpdatedDate();
    }

    public void getUpdatedDate(long lastUpdatedDate) {
        this.context.setState(new NodeState.Builder(this.context.getState()).updatedDate(lastUpdatedDate).build());
    }

    public String getResolvedLabel() {
        if (this.cachedResolvedLabel != null) {
            return this.cachedResolvedLabel;
        }
        String resolvedLabel = this.context.getState().getLabel();
        String id = this.context.getId();
        Locale userLocale = this.owner.navigation.portal.getUserLocale();
        if (this.context.getState().getLabel() != null && ExpressionUtil.isResourceBindingExpression((String)this.context.getState().getLabel())) {
            ResourceBundle bundle = this.owner.navigation.getBundle();
            if (bundle == EmptyResourceBundle.INSTANCE) {
                ResourceBundleService resourceBundleService = (ResourceBundleService)ExoContainerContext.getService(ResourceBundleService.class);
                bundle = resourceBundleService.getResourceBundle(resourceBundleService.getSharedResourceBundleNames(), userLocale);
            }
            resolvedLabel = ExpressionUtil.getExpressionValue((ResourceBundle)bundle, (String)this.context.getState().getLabel());
        } else if (id != null) {
            Locale portalLocale = this.owner.navigation.portal.getLocale();
            DescriptionStorage descriptionStorage = (DescriptionStorage)ExoContainerContext.getService(DescriptionStorage.class);
            State description = descriptionStorage.resolveDescription(id, portalLocale, userLocale);
            if (description != null) {
                resolvedLabel = description.getName();
            }
        }
        if (resolvedLabel == null) {
            resolvedLabel = this.getName();
        }
        return resolvedLabel;
    }

    public void setResolvedLabel(String label) {
        this.cachedResolvedLabel = label;
    }

    public String getEncodedResolvedLabel() {
        return HTMLEntityEncoder.getInstance().encode(this.getResolvedLabel());
    }

    public UserNode getParent() {
        return (UserNode)this.context.getParentNode();
    }

    public boolean hasChildrenRelationship() {
        return this.context.isExpanded();
    }

    public int getChildrenCount() {
        return this.context.getNodeCount();
    }

    public int getChildrenSize() {
        return this.context.getNodeSize();
    }

    public Collection<UserNode> getChildren() {
        return this.context.isExpanded() ? this.context.getNodes() : Collections.emptyList();
    }

    public UserNode getChild(String childName) throws NullPointerException {
        if (this.context.isExpanded()) {
            return (UserNode)this.context.getNode(childName);
        }
        return null;
    }

    public UserNode getChild(int childIndex) throws IndexOutOfBoundsException {
        if (this.context.isExpanded()) {
            return (UserNode)this.context.getNode(childIndex);
        }
        return null;
    }

    public void addChild(UserNode child) {
        this.context.add(null, child.context);
        child.uri = null;
    }

    public void addChild(int index, UserNode child) {
        this.context.add(Integer.valueOf(index), child.context);
        child.uri = null;
    }

    public UserNode addChild(String childName) {
        return (UserNode)this.context.add(null, childName).getNode();
    }

    public boolean removeChild(String childName) {
        return this.context.removeNode(childName);
    }

    UserNode find(String nodeId) {
        return (UserNode)this.context.getDescendantNode(nodeId);
    }

    public String toString() {
        return this.toString(1);
    }

    public String toString(int depth) {
        return this.context.toString(depth, new StringBuilder("UserNode[")).append("]").toString();
    }
}

