/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.event;

import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import javax.portlet.PortletRequest;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.security.csrf.CSRFTokenUtil;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.exception.CSRFException;

public class Event<T> {
    private String name_;
    private T source_;
    private Phase executionPhase_ = Phase.PROCESS;
    private WebuiRequestContext context_;
    private List<EventListener> listeners_;
    private boolean csrfCheck;
    private static final Log LOG = ExoLogger.getLogger(Event.class);

    public Event(T source, String name, WebuiRequestContext context) {
        this.name_ = name;
        this.source_ = source;
        this.context_ = context;
    }

    public String getName() {
        return this.name_;
    }

    public T getSource() {
        return this.source_;
    }

    public Phase getExecutionPhase() {
        return this.executionPhase_;
    }

    public void setExecutionPhase(Phase phase) {
        this.executionPhase_ = phase;
    }

    public WebuiRequestContext getRequestContext() {
        return this.context_;
    }

    public void setRequestContext(WebuiRequestContext context) {
        this.context_ = context;
    }

    public List<EventListener> getEventListeners() {
        return this.listeners_;
    }

    public void setEventListeners(List<EventListener> listeners) {
        this.listeners_ = listeners;
    }

    public boolean isCsrfCheck() {
        return this.csrfCheck;
    }

    public void setCsrfCheck(boolean csrfCheck) {
        this.csrfCheck = csrfCheck;
    }

    public final void broadcast() throws Exception {
        if (this.isCsrfCheck() && !CSRFTokenUtil.check((HttpServletRequest)Event.getRequest())) {
            this.getRequestContext().setResponseComplete(true);
            for (EventListener listener : this.listeners_) {
                LOG.warn("CSRF token is lost or this is an CSRF attack (event={}, listener={})", new Object[]{this.getName(), listener.getClass().getName()});
            }
            throw new CSRFException("CSRF token expired or lost, please reload the page");
        }
        for (EventListener listener : this.listeners_) {
            listener.execute(this);
        }
    }

    private static HttpServletRequest getRequest() {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        if (context != null && context.getRequest() instanceof PortletRequest) {
            context = (WebuiRequestContext)context.getParentAppRequestContext();
        }
        if (context != null) {
            return (HttpServletRequest)context.getRequest();
        }
        LOG.warn((Object)"Can't find portal context");
        return null;
    }

    public static enum Phase {
        ANY,
        DECODE,
        PROCESS,
        RENDER;

    }
}

