/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.storage.api;

import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import org.exoplatform.social.core.ActivityProcessor;
import org.exoplatform.social.core.activity.ActivityFilter;
import org.exoplatform.social.core.activity.model.ActivityShareAction;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.storage.ActivityStorageException;

public interface ActivityStorage {
    public static final String MENTION_CHAR = "@";

    public ExoSocialActivity getActivity(String var1) throws ActivityStorageException;

    public List<ExoSocialActivity> getUserActivities(Identity var1) throws ActivityStorageException;

    public List<ExoSocialActivity> getUserActivities(Identity var1, long var2, long var4) throws ActivityStorageException;

    public List<String> getUserIdsActivities(Identity var1, long var2, long var4) throws ActivityStorageException;

    default public List<ExoSocialActivity> getActivitiesByFilter(Identity viewerIdentity, ActivityFilter activityFilter, long offset, long limit) {
        throw new UnsupportedOperationException();
    }

    default public List<String> getActivityIdsByFilter(Identity viewerIdentity, ActivityFilter activityFilter, long offset, long limit) {
        throw new UnsupportedOperationException();
    }

    public List<ExoSocialActivity> getUserActivitiesForUpgrade(Identity var1, long var2, long var4) throws ActivityStorageException;

    public List<ExoSocialActivity> getActivities(Identity var1, Identity var2, long var3, long var5) throws ActivityStorageException;

    public void saveComment(ExoSocialActivity var1, ExoSocialActivity var2) throws ActivityStorageException;

    public ExoSocialActivity saveActivity(Identity var1, ExoSocialActivity var2) throws ActivityStorageException;

    public ExoSocialActivity getParentActivity(ExoSocialActivity var1) throws ActivityStorageException;

    public void deleteActivity(String var1) throws ActivityStorageException;

    public void deleteComment(String var1, String var2) throws ActivityStorageException;

    public int getNumberOfUserActivities(Identity var1) throws ActivityStorageException;

    default public int getActivitiesCountByFilter(Identity viewerIdentity, ActivityFilter activityFilter) {
        throw new UnsupportedOperationException();
    }

    public int getNumberOfUserActivitiesForUpgrade(Identity var1) throws ActivityStorageException;

    public int getNumberOfNewerOnUserActivities(Identity var1, ExoSocialActivity var2);

    public List<ExoSocialActivity> getNewerOnUserActivities(Identity var1, ExoSocialActivity var2, int var3);

    public int getNumberOfOlderOnUserActivities(Identity var1, ExoSocialActivity var2);

    public List<ExoSocialActivity> getOlderOnUserActivities(Identity var1, ExoSocialActivity var2, int var3);

    public List<ExoSocialActivity> getActivityFeed(Identity var1, int var2, int var3);

    public List<String> getActivityIdsFeed(Identity var1, int var2, int var3);

    @Deprecated
    public List<ExoSocialActivity> getActivityFeedForUpgrade(Identity var1, int var2, int var3);

    public int getNumberOfActivitesOnActivityFeed(Identity var1);

    public int getNumberOfActivitesOnActivityFeedForUpgrade(Identity var1);

    public int getNumberOfNewerOnActivityFeed(Identity var1, ExoSocialActivity var2);

    public List<ExoSocialActivity> getNewerOnActivityFeed(Identity var1, ExoSocialActivity var2, int var3);

    public int getNumberOfOlderOnActivityFeed(Identity var1, ExoSocialActivity var2);

    public List<ExoSocialActivity> getOlderOnActivityFeed(Identity var1, ExoSocialActivity var2, int var3);

    public List<ExoSocialActivity> getActivitiesOfConnections(Identity var1, int var2, int var3);

    public List<String> getActivityIdsOfConnections(Identity var1, int var2, int var3);

    @Deprecated
    public List<ExoSocialActivity> getActivitiesOfConnectionsForUpgrade(Identity var1, int var2, int var3);

    public int getNumberOfActivitiesOfConnections(Identity var1);

    public int getNumberOfActivitiesOfConnectionsForUpgrade(Identity var1);

    public List<ExoSocialActivity> getActivitiesOfIdentity(Identity var1, long var2, long var4);

    public int getNumberOfNewerOnActivitiesOfConnections(Identity var1, ExoSocialActivity var2);

    public List<ExoSocialActivity> getNewerOnActivitiesOfConnections(Identity var1, ExoSocialActivity var2, long var3);

    public int getNumberOfOlderOnActivitiesOfConnections(Identity var1, ExoSocialActivity var2);

    public List<ExoSocialActivity> getOlderOnActivitiesOfConnections(Identity var1, ExoSocialActivity var2, int var3);

    public List<ExoSocialActivity> getUserSpacesActivities(Identity var1, int var2, int var3);

    public List<String> getUserSpacesActivityIds(Identity var1, int var2, int var3);

    public List<ExoSocialActivity> getUserSpacesActivitiesForUpgrade(Identity var1, int var2, int var3);

    public int getNumberOfUserSpacesActivities(Identity var1);

    public int getNumberOfUserSpacesActivitiesForUpgrade(Identity var1);

    public int getNumberOfNewerOnUserSpacesActivities(Identity var1, ExoSocialActivity var2);

    public List<ExoSocialActivity> getNewerOnUserSpacesActivities(Identity var1, ExoSocialActivity var2, int var3);

    public int getNumberOfOlderOnUserSpacesActivities(Identity var1, ExoSocialActivity var2);

    public List<ExoSocialActivity> getOlderOnUserSpacesActivities(Identity var1, ExoSocialActivity var2, int var3);

    public List<ExoSocialActivity> getComments(ExoSocialActivity var1, boolean var2, int var3, int var4);

    default public List<ExoSocialActivity> getComments(ExoSocialActivity activity, boolean loadSubComments, int offset, int limit, boolean sortDescending) {
        return this.getComments(activity, loadSubComments, offset, limit);
    }

    public int getNumberOfComments(ExoSocialActivity var1);

    default public int getNumberOfAllComments(String activityId) {
        throw new UnsupportedOperationException();
    }

    public int getNumberOfNewerComments(ExoSocialActivity var1, ExoSocialActivity var2);

    public List<ExoSocialActivity> getNewerComments(ExoSocialActivity var1, ExoSocialActivity var2, int var3);

    public int getNumberOfOlderComments(ExoSocialActivity var1, ExoSocialActivity var2);

    public List<ExoSocialActivity> getOlderComments(ExoSocialActivity var1, ExoSocialActivity var2, int var3);

    public SortedSet<ActivityProcessor> getActivityProcessors();

    public void updateActivity(ExoSocialActivity var1) throws ActivityStorageException;

    public int getNumberOfNewerOnActivityFeed(Identity var1, Long var2);

    public int getNumberOfNewerOnUserActivities(Identity var1, Long var2);

    public int getNumberOfNewerOnActivitiesOfConnections(Identity var1, Long var2);

    public int getNumberOfNewerOnUserSpacesActivities(Identity var1, Long var2);

    public int getNumberOfSpaceActivities(Identity var1);

    public int getNumberOfSpaceActivitiesForUpgrade(Identity var1);

    public List<ExoSocialActivity> getSpaceActivities(Identity var1, int var2, int var3);

    public List<String> getSpaceActivityIds(Identity var1, int var2, int var3);

    public List<ExoSocialActivity> getSpaceActivitiesForUpgrade(Identity var1, int var2, int var3);

    public List<ExoSocialActivity> getActivitiesByPoster(Identity var1, int var2, int var3);

    public List<ExoSocialActivity> getActivitiesByPoster(Identity var1, int var2, int var3, String ... var4);

    public int getNumberOfActivitiesByPoster(Identity var1);

    public int getNumberOfActivitiesByPoster(Identity var1, Identity var2);

    public List<ExoSocialActivity> getNewerOnSpaceActivities(Identity var1, ExoSocialActivity var2, int var3);

    public int getNumberOfNewerOnSpaceActivities(Identity var1, ExoSocialActivity var2);

    public List<ExoSocialActivity> getOlderOnSpaceActivities(Identity var1, ExoSocialActivity var2, int var3);

    public int getNumberOfOlderOnSpaceActivities(Identity var1, ExoSocialActivity var2);

    public int getNumberOfNewerOnSpaceActivities(Identity var1, Long var2);

    public List<ExoSocialActivity> getNewerFeedActivities(Identity var1, Long var2, int var3);

    public List<ExoSocialActivity> getNewerUserActivities(Identity var1, Long var2, int var3);

    public List<ExoSocialActivity> getNewerUserSpacesActivities(Identity var1, Long var2, int var3);

    public List<ExoSocialActivity> getNewerActivitiesOfConnections(Identity var1, Long var2, int var3);

    public List<ExoSocialActivity> getNewerSpaceActivities(Identity var1, Long var2, int var3);

    public List<ExoSocialActivity> getOlderFeedActivities(Identity var1, Long var2, int var3);

    public List<ExoSocialActivity> getOlderUserActivities(Identity var1, Long var2, int var3);

    public List<ExoSocialActivity> getOlderUserSpacesActivities(Identity var1, Long var2, int var3);

    public List<ExoSocialActivity> getOlderActivitiesOfConnections(Identity var1, Long var2, int var3);

    public List<ExoSocialActivity> getOlderSpaceActivities(Identity var1, Long var2, int var3);

    public int getNumberOfOlderOnActivityFeed(Identity var1, Long var2);

    public int getNumberOfOlderOnUserActivities(Identity var1, Long var2);

    public int getNumberOfOlderOnActivitiesOfConnections(Identity var1, Long var2);

    public int getNumberOfOlderOnUserSpacesActivities(Identity var1, Long var2);

    public int getNumberOfOlderOnSpaceActivities(Identity var1, Long var2);

    public List<ExoSocialActivity> getNewerComments(ExoSocialActivity var1, Long var2, int var3);

    public List<ExoSocialActivity> getOlderComments(ExoSocialActivity var1, Long var2, int var3);

    public int getNumberOfNewerComments(ExoSocialActivity var1, Long var2);

    public int getNumberOfOlderComments(ExoSocialActivity var1, Long var2);

    public List<ExoSocialActivity> getAllActivities(int var1, int var2);

    public List<ExoSocialActivity> getSubComments(ExoSocialActivity var1);

    public List<ExoSocialActivity> getActivities(List<String> var1);

    default public Set<Long> getStreamFeedOwnerIds(Identity identity) {
        throw new UnsupportedOperationException();
    }

    default public ActivityShareAction createShareActivityAction(ActivityShareAction activityShareAction) {
        throw new UnsupportedOperationException();
    }

    default public ExoSocialActivity hideActivity(String activityId) {
        throw new UnsupportedOperationException();
    }

    default public boolean isActivityExists(String activityId) {
        throw new UnsupportedOperationException();
    }

    default public ExoSocialActivity pinActivity(String activityId, String userIdentityId) {
        throw new UnsupportedOperationException();
    }

    default public ExoSocialActivity unpinActivity(String activityId) {
        throw new UnsupportedOperationException();
    }

    default public List<Long> getActivityCategoryIds(long spaceIdentityId) {
        throw new UnsupportedOperationException();
    }

    default public List<Long> getActivityCategoryIds(Set<Long> streamFeedOwnerIds) {
        throw new UnsupportedOperationException();
    }

    public static enum TimestampType {
        NEWER,
        OLDER,
        UPDATED;

        private Long number;

        public TimestampType from(Long number) {
            this.number = number;
            return this;
        }

        public Long get() {
            return this.number;
        }
    }
}

